/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardAction;
import org.refcodes.checkerboard.Player;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridDimensionImpl;

public class GridDimensionChangedEvent<P extends Player<P, S>, S>
extends AbstractCheckerboardEvent<P, S>
implements GridDimension {
    public static final CheckerboardAction ACTION = CheckerboardAction.GRID_DIMENSION_CHANGED;
    private final int _height;
    private final int _width;
    private final GridDimension _precedingDimension;

    public GridDimensionChangedEvent(int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, Checkerboard<P, S> aSource) {
        super(ACTION, aSource);
        this._width = aWidth;
        this._height = aHeight;
        this._precedingDimension = new GridDimensionImpl(aPrecedingWidth, aPrecedingHeigt);
    }

    public int getGridHeight() {
        return this._height;
    }

    public int getGridWidth() {
        return this._width;
    }

    public GridDimension getPrecedingGridDimension() {
        return this._precedingDimension;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this._width + ":" + this._height + ")@" + this.hashCode();
    }
}

