/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardAction;
import org.refcodes.checkerboard.Player;
import org.refcodes.graphical.Position;

public class GridPositionClickedEvent<P extends Player<P, S>, S>
extends AbstractCheckerboardEvent<P, S>
implements Position {
    public static final CheckerboardAction ACTION = CheckerboardAction.GRID_POSITION_CLICKED;
    private final int _posX;
    private final int _posY;

    public GridPositionClickedEvent(int aPosX, int aPosY, Checkerboard<P, S> aSource) {
        super(ACTION, aSource);
        this._posX = aPosX;
        this._posY = aPosY;
    }

    public GridPositionClickedEvent(Position aPosition, Checkerboard<P, S> aSource) {
        super(ACTION, aSource);
        this._posX = aPosition.getPositionX();
        this._posY = aPosition.getPositionY();
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", x := " + this._posX + ", y := " + this._posY;
    }
}

