/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractPlayerEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAction;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.PositionImpl;
import org.refcodes.graphical.Vector;

public class PlayerPositionChangedEvent<P extends Player<P, ?>>
extends AbstractPlayerEvent<P>
implements Position,
Vector {
    public static final PlayerAction ACTION = PlayerAction.POSITION_CHANGED;
    private final int _posX;
    private final int _posY;
    private final Position _precedingPosition;

    public PlayerPositionChangedEvent(int aPosX, int aPosY, int aPrePosX, int aPrePosY, P aSource) {
        super(ACTION, aSource);
        this._posX = aPosX;
        this._posY = aPosY;
        this._precedingPosition = new PositionImpl(aPrePosX, aPrePosY);
    }

    public PlayerPositionChangedEvent(Position aPosition, Position aPrecedingPosition, P aSource) {
        super(ACTION, aSource);
        this._posX = aPosition.getPositionX();
        this._posY = aPosition.getPositionY();
        this._precedingPosition = aPrecedingPosition;
    }

    public Position getPrecedingPosition() {
        return this._precedingPosition;
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    public int getVectorX() {
        return this._posX - this._precedingPosition.getPositionX();
    }

    public int getVectorY() {
        return this._posY - this._precedingPosition.getPositionY();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", x := " + this._posX + ", y := " + this._posY + " (state before: " + this._precedingPosition + ")";
    }
}

