/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardViewerEvent;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.CheckerboardViewerAction;
import org.refcodes.checkerboard.Player;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionImpl;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ViewportOffsetImpl;

public class ViewportDimensionChangedEvent<P extends Player<P, S>, S>
extends AbstractCheckerboardViewerEvent<P, S>
implements ViewportDimension {
    public static final CheckerboardViewerAction ACTION = CheckerboardViewerAction.VIEWPORT_DIMENSION_CHANGED;
    private final int _height;
    private final int _width;
    private final ViewportDimension _precedingDimension;
    private final ViewportOffset _viewportOffset;

    public ViewportDimensionChangedEvent(int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, int aOffsetX, int aOffsetY, CheckerboardViewer<P, S, ?> aSource) {
        super(ACTION, aSource);
        this._width = aWidth;
        this._height = aHeight;
        this._precedingDimension = new ViewportDimensionImpl(aPrecedingWidth, aPrecedingHeigt);
        this._viewportOffset = new ViewportOffsetImpl(aOffsetX, aOffsetY);
    }

    public int getViewportHeight() {
        return this._height;
    }

    public int getViewportWidth() {
        return this._width;
    }

    public ViewportDimension getPrecedingViewportDimension() {
        return this._precedingDimension;
    }

    public ViewportOffset getViewportOffset() {
        return this._viewportOffset;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this._width + ":" + this._height + ")@" + this.hashCode();
    }
}

