/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardViewerEvent;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.CheckerboardViewerAction;
import org.refcodes.checkerboard.Player;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ViewportOffsetImpl;

public class ViewportOffsetChangedEvent<P extends Player<P, S>, S>
extends AbstractCheckerboardViewerEvent<P, S>
implements ViewportOffset {
    public static final CheckerboardViewerAction ACTION = CheckerboardViewerAction.VIEWPORT_OFFSET_CHANGED;
    private final int _offsetX;
    private final int _offsetY;
    private final ViewportOffset _precedingOffset;

    public ViewportOffsetChangedEvent(int aOffsetY, int aOffsetX, int aPrecedingOffsetX, int aPrecedingOffsetY, CheckerboardViewer<P, S, ?> aSource) {
        super(ACTION, aSource);
        this._offsetX = aOffsetX;
        this._offsetY = aOffsetY;
        this._precedingOffset = new ViewportOffsetImpl(aPrecedingOffsetX, aPrecedingOffsetY);
    }

    public int getViewportOffsetX() {
        return this._offsetX;
    }

    public int getViewportOffsetY() {
        return this._offsetY;
    }

    public ViewportOffset getPrecedingViewportOffset() {
        return this._precedingOffset;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this._offsetX + ":" + this._offsetY + ")@" + this.hashCode();
    }
}

