/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.Neighbourhood;

public enum VonNeumannNeighbourhood implements Neighbourhood<VonNeumannNeighbourhood>
{
    LEFT(-1, 0),
    TOP(0, -1),
    RIGHT(1, 0),
    BOTTOM(0, 1);

    private int _posX;
    private int _posY;

    private VonNeumannNeighbourhood(int aPosX, int aPosY) {
        this._posX = aPosX;
        this._posY = aPosY;
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    @Override
    public VonNeumannNeighbourhood clockwiseNext() {
        return switch (this) {
            case TOP -> RIGHT;
            case RIGHT -> BOTTOM;
            case BOTTOM -> LEFT;
            case LEFT -> TOP;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public VonNeumannNeighbourhood clockwisePrevious() {
        return switch (this) {
            case TOP -> LEFT;
            case LEFT -> BOTTOM;
            case BOTTOM -> RIGHT;
            case RIGHT -> TOP;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

