package org.refcodes.checkerboard;

/**
 * The Class AbstractCheckerboardEvent.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public abstract class AbstractCheckerboardEvent<P extends Player<P, S>, S> implements CheckerboardEvent<P, S> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Checkerboard<P, S> _source;

	private CheckerboardAction _action;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new abstract checkerboard event.
	 *
	 * @param aAction the action
	 * @param aSource The according source (origin).
	 */
	public AbstractCheckerboardEvent( CheckerboardAction aAction, Checkerboard<P, S> aSource ) {
		_source = aSource;
		_action = aAction;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public CheckerboardAction getAction() {
		return _action;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Checkerboard<P, S> getSource() {
		return _source;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "action := " + _action;

	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class AbstractPlayerCheckerboardEvent.
	 *
	 * @param <P> the generic type
	 * @param <S> the generic type
	 */
	public abstract static class AbstractPlayerCheckerboardEvent<P extends Player<P, S>, S> extends AbstractCheckerboardEvent<P, S> implements PlayerAccessor<P> {

		// /////////////////////////////////////////////////////////////////////
		// STATICS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// CONSTANTS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////

		private final P _player;

		// /////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new abstract player checkerboard event.
		 *
		 * @param aAction the action
		 * @param aPlayer the player
		 * @param aSource The according source (origin).
		 */
		public AbstractPlayerCheckerboardEvent( CheckerboardAction aAction, P aPlayer, Checkerboard<P, S> aSource ) {
			super( aAction, aSource );
			_player = aPlayer;
		}

		// /////////////////////////////////////////////////////////////////////
		// INJECTION:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// METHODS:
		/**
		 * Gets the player.
		 *
		 * @return the player
		 */
		// /////////////////////////////////////////////////////////////////////
		@Override
		public P getPlayer() {
			return _player;
		}

		// /////////////////////////////////////////////////////////////////////
		// HOOKS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// HELPER:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// INNER CLASSES:
		// /////////////////////////////////////////////////////////////////////

	}
}
