// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.collection.impls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.refcodes.collection.Properties;
import org.refcodes.collection.Property;
import org.refcodes.collection.Relation;

public class PropertiesImpl implements Properties {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected Map<String, String> _properties = new HashMap<>();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	protected PropertiesImpl() {}

	public PropertiesImpl( Properties aProperties ) {
		for ( String eKey : aProperties.values() ) {
			_properties.put( eKey, aProperties.get( eKey ) );
		}
	}

	public PropertiesImpl( Map<?, ?> aProperties ) {
		for ( Object eKey : aProperties.values() ) {
			_properties.put( eKey.toString(), aProperties.get( eKey ).toString() );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public boolean containsKey( String aKey ) {
		return _properties.containsKey( aKey );
	}

	@Override
	public String get( String aKey ) {
		return _properties.get( aKey );
	}

	@Override
	public Set<String> keySet() {
		return _properties.keySet();
	}

	@Override
	public Collection<String> values() {
		return _properties.values();
	}

	@Override
	public int size() {
		return _properties.size();
	}

	@Override
	public boolean isEmpty() {
		return _properties.isEmpty();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	public static class MutablePropertiesImpl extends PropertiesImpl implements MutableProperties {

		public MutablePropertiesImpl() {
			super();
		}

		public MutablePropertiesImpl( Map<?, ?> aProperties ) {
			super( aProperties );
		}

		public MutablePropertiesImpl( Properties aProperties ) {
			super( aProperties );
		}

		@Override
		public void clear() {
			_properties.clear();

		}

		@Override
		public String put( String aKey, String aValue ) {
			return _properties.put( aKey, aValue );
		}

		@Override
		public String put( Relation<String, String> aRelation ) {
			return _properties.put( aRelation.getKey(), aRelation.getValue() );
		}

		@Override
		public String put( Property aProperty ) {
			return _properties.put( aProperty.getKey(), aProperty.getValue() );
		}

		@Override
		public String removeKey( String aKey ) {
			return _properties.remove( aKey );
		}
	}

	public static class PropertiesBuilderImpl extends MutablePropertiesImpl implements PropertiesBuilder {

		@Override
		public PropertiesBuilder with( String aKey, String aValue ) {
			put( aKey, aValue );
			return this;
		}

		@Override
		public PropertiesBuilder with( Relation<String, String> aRelation ) {
			put( aRelation );
			return this;
		}

		@Override
		public PropertiesBuilder withProperty( String aKey, String aValue ) {
			put( aKey, aValue );
			return this;
		}

		@Override
		public PropertiesBuilder withProperty( Property aProperty ) {
			put( aProperty );
			return this;
		}
	}
}
