// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.collection.impls;

import org.refcodes.collection.Relation;

/**
 * Property accessor needful in some cases.
 *
 * @param <K> The generic key's type
 * @param <V> The generic value's type
 */
public class RelationImpl<K, V> implements Relation<K, V> {

	protected K _key;
	protected V _value;
	
	public RelationImpl() {};

	/**
	 * Constructs a property accessor.
	 * 
	 * @param aKey The key for the key-value property.
	 * @param aValue The value for the key-value property.
	 */
	public RelationImpl( K aKey, V aValue ) {
		_key = aKey;
		_value = aValue;
	}

	@Override
	public K getKey() {
		return _key;
	}

	@Override
	public V getValue() {
		return _value;
	}

	@Override
	public void setKey( K aKey ) {
		_key = aKey;
	}

	@Override
	public void setValue( V aValue ) {
		_value = aValue;
	}
	
	@Override
	public Relation<K, V> withKey( K aKey ) {
		_key = aKey;
		return this;
	}

	@Override
	public Relation<K, V> withValue( V aValue ) {
		_value = aValue;
		return this;
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _key + " := " + _value + ")@" + hashCode();
	}
}
