/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import java.io.Flushable;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.component.ClosedAccessor;
import org.refcodes.controlflow.RetryTimeout;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.RuntimeIOException;

public interface Closable {
    public void close() throws IOException;

    default public void closeUnchecked() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    default public void closeQuietly() {
        if (this instanceof Flushable) {
            try {
                ((Flushable)((Object)this)).flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RetryTimeout theRetryTimeout = new RetryTimeout((long)IoTimeout.NORM.getTimeMillis(), IoRetryCount.NORM.getValue().intValue());
        while (theRetryTimeout.hasNextRetry()) {
            try {
                this.close();
                return;
            }
            catch (IOException iOException) {
            }
        }
    }

    default public void closeIn(int aCloseMillis) {
        final Timer theTimer = new Timer();
        theTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Closable.this.close();
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
                finally {
                    theTimer.cancel();
                }
            }
        }, aCloseMillis);
    }

    public static interface CloseAutomaton
    extends Closable,
    ClosedAccessor {
        public boolean isClosable();
    }

    public static interface CloseBuilder<B extends CloseBuilder<B>> {
        public B withClose() throws IOException;

        public B withCloseQuietly();

        public B withCloseIn(int var1);

        default public B withCloseUnchecked() {
            try {
                return this.withClose();
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }
}

