/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.configuration.ext.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.refcodes.component.OpenException;
import org.refcodes.configuration.AbstractPropertiesDecorator;
import org.refcodes.configuration.EnvironmentProperties;
import org.refcodes.configuration.JavaProperties;
import org.refcodes.configuration.JavaPropertiesBuilder;
import org.refcodes.configuration.JsonProperties;
import org.refcodes.configuration.JsonPropertiesBuilder;
import org.refcodes.configuration.ProfilePropertiesProjection;
import org.refcodes.configuration.Properties;
import org.refcodes.configuration.PropertiesBuilderImpl;
import org.refcodes.configuration.PropertiesPrecedence;
import org.refcodes.configuration.PropertiesPrecedenceBuilderComposite;
import org.refcodes.configuration.ReloadMode;
import org.refcodes.configuration.ResourceProperties;
import org.refcodes.configuration.SystemProperties;
import org.refcodes.configuration.TomlProperties;
import org.refcodes.configuration.TomlPropertiesBuilder;
import org.refcodes.configuration.YamlProperties;
import org.refcodes.configuration.YamlPropertiesBuilder;
import org.refcodes.configuration.ext.console.ArgsParserProperties;
import org.refcodes.configuration.ext.console.ArgsParserPropertiesImpl;
import org.refcodes.configuration.ext.obfuscation.ObfuscationPropertiesDecorator;
import org.refcodes.configuration.ext.obfuscation.ObfuscationResourcePropertiesBuilderDecorator;
import org.refcodes.configuration.ext.runtime.RuntimeProperties;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.Condition;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.exception.BugException;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosKeyImpl;
import org.refcodes.security.alt.chaos.ChaosTextDecrypterImpl;
import org.refcodes.security.alt.chaos.ChaosTextEncrypterImpl;
import org.refcodes.textual.Font;

public class RuntimePropertiesImpl
extends AbstractPropertiesDecorator<Properties>
implements RuntimeProperties {
    private ArgsParserProperties _argsParserProperties = null;
    private List<ResourceProperties> _resourceProperties = new ArrayList<ResourceProperties>();
    private PropertiesPrecedence.PropertiesPrecedenceBuilder _propertiesPrecedence = new PropertiesPrecedenceBuilderComposite(new Properties[0]);
    private String _secret = this.toEncrypted(SystemContext.HOST.toSystemSequence());
    private boolean _isPostConstructed = false;

    public RuntimePropertiesImpl() {
        this._argsParserProperties = new ArgsParserPropertiesImpl();
    }

    public RuntimePropertiesImpl(String[] aArgs) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aArgs);
    }

    public RuntimePropertiesImpl(Condition aRootCondition) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aRootCondition);
    }

    public RuntimePropertiesImpl(SystemContext aObfuscationMode) {
        this._argsParserProperties = new ArgsParserPropertiesImpl();
        this._secret = this.toEncrypted(aObfuscationMode.toSystemSequence());
    }

    public RuntimePropertiesImpl(String[] aArgs, SystemContext aObfuscationMode) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aArgs);
        this._secret = this.toEncrypted(aObfuscationMode.toSystemSequence());
    }

    public RuntimePropertiesImpl(Condition aRootCondition, SystemContext aObfuscationMode) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aRootCondition);
        this._secret = this.toEncrypted(aObfuscationMode.toSystemSequence());
    }

    public RuntimePropertiesImpl(String aSecret) {
        this._argsParserProperties = new ArgsParserPropertiesImpl();
        this._secret = this.toEncrypted(aSecret);
    }

    public RuntimePropertiesImpl(String[] aArgs, String aSecret) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aArgs);
        this._secret = this.toEncrypted(aSecret);
    }

    public RuntimePropertiesImpl(Condition aRootCondition, String aSecret) {
        this._argsParserProperties = new ArgsParserPropertiesImpl(aRootCondition);
        this._secret = this.toEncrypted(aSecret);
    }

    private void postConstruct() {
        this._propertiesPrecedence.prependProperties((Properties)new ObfuscationPropertiesDecorator((Properties)new EnvironmentProperties(), this.toDecrypted(this._secret)));
        this._propertiesPrecedence.prependProperties((Properties)new ObfuscationPropertiesDecorator((Properties)new SystemProperties(), this.toDecrypted(this._secret)));
        this._propertiesPrecedence.prependProperties((Properties)new ObfuscationPropertiesDecorator((Properties)this._argsParserProperties, this.toDecrypted(this._secret)));
        this.setProperties((Properties)new ProfilePropertiesProjection((Properties)this._propertiesPrecedence, new String[0]));
    }

    public void setRootCondition(Condition aRootCondition) {
        if (this._isPostConstructed) {
            throw new IllegalStateException("The runtime properties have already been post-constructed as the properties have already been accessed, you must call this method before first accessing any property!");
        }
        this._argsParserProperties = new ArgsParserPropertiesImpl(aRootCondition);
    }

    public void setSecret(String aSecret) {
        if (this._isPostConstructed) {
            throw new IllegalStateException("The runtime properties have already been post-constructed as the properties have already been accessed, you must call this method before first accessing any property!");
        }
        this._secret = this.toEncrypted(aSecret);
    }

    @Override
    public void setObfuscationMode(SystemContext aObfuscationMode) {
        if (this._isPostConstructed) {
            throw new IllegalStateException("The runtime properties have already been post-constructed as the properties have already been accessed, you must call this method before first accessing any property!");
        }
        this._secret = this.toEncrypted(aObfuscationMode.toSystemSequence());
    }

    @Override
    public RuntimeProperties withProperties(Properties aProperties) {
        this.addProperties(aProperties);
        return this;
    }

    protected void addProperties(Properties aProperties) {
        if (aProperties instanceof ResourceProperties.ResourcePropertiesBuilder) {
            try {
                ObfuscationResourcePropertiesBuilderDecorator theObfuscation = new ObfuscationResourcePropertiesBuilderDecorator((ResourceProperties.ResourcePropertiesBuilder)aProperties, this.toDecrypted(this._secret));
                this._resourceProperties.add((ResourceProperties)theObfuscation);
                this._propertiesPrecedence.appendProperties((Properties)theObfuscation);
            }
            catch (OpenException e) {
                this._resourceProperties.add((ResourceProperties)aProperties);
                this._propertiesPrecedence.appendProperties(aProperties);
            }
        } else if (aProperties instanceof ResourceProperties) {
            ObfuscationPropertiesDecorator theObfuscation = new ObfuscationPropertiesDecorator((Properties)((ResourceProperties)aProperties), this.toDecrypted(this._secret));
            this._resourceProperties.add((ResourceProperties)aProperties);
            this._propertiesPrecedence.appendProperties((Properties)theObfuscation);
        }
    }

    public RuntimeProperties withFile(File aFile) throws IOException, ParseException {
        this.addProperties(aFile);
        return this;
    }

    public RuntimeProperties withInputStream(InputStream aInputStream) throws IOException, ParseException {
        this.addProperties(aInputStream);
        return this;
    }

    public RuntimeProperties withFilePath(String aFilePath) throws IOException, ParseException {
        this.addProperties(aFilePath);
        return this;
    }

    public RuntimeProperties withUrl(URL aUrl) throws IOException, ParseException {
        this.addProperties(aUrl);
        return this;
    }

    @Override
    public RuntimeProperties withParseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        this.evalArgs(aArgs);
        return this;
    }

    public void errorLn(String aLine) {
        this._argsParserProperties.errorLn(aLine);
    }

    public List<? extends Operand<?>> evalArgs(List<String> aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        return this._argsParserProperties.evalArgs(aArgs);
    }

    public List<? extends Operand<?>> evalArgs(String aToPath, List<String> aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        return this._argsParserProperties.evalArgs(aToPath, aArgs);
    }

    public List<? extends Operand<?>> evalArgs(String aToPath, String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        return this._argsParserProperties.evalArgs(aToPath, aArgs);
    }

    public List<? extends Operand<?>> evalArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        return this._argsParserProperties.evalArgs(aArgs);
    }

    public Condition getRootCondition() {
        return this._argsParserProperties.getRootCondition();
    }

    public void printBanner() {
        this._argsParserProperties.printBanner();
    }

    public void printCopyrightNote() {
        this._argsParserProperties.printCopyrightNote();
    }

    public void printDescription() {
        this._argsParserProperties.printDescription();
    }

    public void printHelp() {
        this._argsParserProperties.printHelp();
    }

    public void printLicenseNote() {
        this._argsParserProperties.printLicenseNote();
    }

    public void printLn() {
        this._argsParserProperties.printLn();
    }

    public void printLn(String aLine) {
        this._argsParserProperties.printLn(aLine);
    }

    public void printOptions() {
        this._argsParserProperties.printOptions();
    }

    public void printSeparatorLn() {
        this._argsParserProperties.printSeparatorLn();
    }

    public void printUsage() {
        this._argsParserProperties.printUsage();
    }

    public void reset() {
        this._argsParserProperties.reset();
    }

    public void setBannerFont(Font aBannerFont) {
        this._argsParserProperties.setBannerFont(aBannerFont);
    }

    public void setBannerFontPalette(char[] aColorPalette) {
        this._argsParserProperties.setBannerFontPalette(aColorPalette);
    }

    public void setConsoleWidth(int aConsoleWidth) {
        this._argsParserProperties.setConsoleWidth(aConsoleWidth);
    }

    public void setCopyrightNote(String aCopyrightNote) {
        this._argsParserProperties.setCopyrightNote(aCopyrightNote);
    }

    public void setDescription(String aDescription) {
        this._argsParserProperties.setDescription(aDescription);
    }

    public void setErrorOut(PrintStream aErrorOut) {
        this._argsParserProperties.setErrorOut(aErrorOut);
    }

    public void setLicenseNote(String aLicenseNote) {
        this._argsParserProperties.setLicenseNote(aLicenseNote);
    }

    public void setLineBreak(String aLineBreak) {
        this._argsParserProperties.setLineBreak(aLineBreak);
    }

    public void setMaxConsoleWidth(int aMaxConsoleWidth) {
        this._argsParserProperties.setMaxConsoleWidth(aMaxConsoleWidth);
    }

    public void setName(String aName) {
        this._argsParserProperties.setName(aName);
    }

    public void setSeparatorChar(char aSeparatorChar) {
        this._argsParserProperties.setSeparatorChar(aSeparatorChar);
    }

    public void setStandardOut(PrintStream aStandardOut) {
        this._argsParserProperties.setStandardOut(aStandardOut);
    }

    public void setSyntaxNotation(SyntaxNotation aSyntaxNotation) {
        this._argsParserProperties.setSyntaxNotation(aSyntaxNotation);
    }

    public void setTitle(String aTitle) {
        this._argsParserProperties.setTitle(aTitle);
    }

    public void setUsageLabel(String aUsageLabel) {
        this._argsParserProperties.setUsageLabel(aUsageLabel);
    }

    public Properties reload() throws IOException, IllegalStateException, ParseException {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        for (int i = this._resourceProperties.size() - 1; i >= 0; --i) {
            theProperties.insert(this._resourceProperties.get(i).reload());
        }
        return theProperties;
    }

    public Properties reload(ReloadMode aReloadMode) throws IOException, IllegalStateException, ParseException {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        for (int i = this._resourceProperties.size() - 1; i >= 0; --i) {
            theProperties.insert(this._resourceProperties.get(i).reload(aReloadMode));
        }
        return theProperties;
    }

    public char getDelimiter() {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.getDelimiter();
    }

    public int size() {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.size();
    }

    public boolean containsKey(Object aKey) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.containsKey(aKey);
    }

    public boolean isEmpty() {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.isEmpty();
    }

    public String get(Object aKey) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.get(aKey);
    }

    public Set<String> keySet() {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.keySet();
    }

    public Collection<String> values() {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.values();
    }

    public Properties retrieveFrom(String aFromPath) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.retrieveFrom(aFromPath);
    }

    public Properties retrieveTo(String aToPath) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.retrieveTo(aToPath);
    }

    public Properties childrenOf(String aParentPath) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.childrenOf(aParentPath);
    }

    public Object toDataStructure(String aFromPath) {
        if (this.getProperties() == null) {
            throw new IllegalStateException("You must properly construct and then initialize your instance via #postConstruct() !");
        }
        return super.toDataStructure(aFromPath);
    }

    protected Properties getProperties() {
        if (!this._isPostConstructed) {
            this.postConstruct();
        }
        return super.getProperties();
    }

    private String toEncrypted(String aValue) {
        try {
            return new ChaosTextEncrypterImpl((ChaosKey)new ChaosKeyImpl(SystemContext.HOST_USER_APPLICATION.toSystemSequence())).toEncrypted(aValue);
        }
        catch (EncryptionException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
    }

    private String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypterImpl((ChaosKey)new ChaosKeyImpl(SystemContext.HOST_USER_APPLICATION.toSystemSequence())).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] toByteArray(InputStream aInputStream) throws IOException {
        int eRead;
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        byte[] theData = new byte[16384];
        while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
            theBuffer.write(theData, 0, eRead);
        }
        theBuffer.flush();
        return theBuffer.toByteArray();
    }

    protected void addProperties(File aFile) throws IOException, ParseException {
        TomlPropertiesBuilder eProperties = null;
        try {
            eProperties = new TomlPropertiesBuilder(aFile, true);
        }
        catch (ParseException e1) {
            try {
                eProperties = new JavaPropertiesBuilder(aFile, true);
            }
            catch (ParseException e2) {
                try {
                    eProperties = new YamlPropertiesBuilder(aFile, true);
                }
                catch (ParseException e3) {
                    try {
                        eProperties = new JsonPropertiesBuilder(aFile, true);
                    }
                    catch (ParseException e4) {
                        throw new ParseException("Cannot parse the properties from the given file <" + (aFile != null ? aFile.getAbsolutePath() : null) + "!>", 0);
                    }
                }
            }
        }
        try {
            eProperties = new ObfuscationResourcePropertiesBuilderDecorator((ResourceProperties.ResourcePropertiesBuilder)eProperties, this.toDecrypted(this._secret));
        }
        catch (OpenException openException) {
            // empty catch block
        }
        this._resourceProperties.add((ResourceProperties)eProperties);
        this._propertiesPrecedence.appendProperties((Properties)eProperties);
    }

    protected void addProperties(InputStream aInputStream) throws IOException, ParseException {
        TomlProperties eProperties = null;
        byte[] theBytes = RuntimePropertiesImpl.toByteArray(aInputStream);
        try {
            eProperties = new TomlProperties((InputStream)new ByteArrayInputStream(theBytes));
        }
        catch (ParseException e1) {
            try {
                eProperties = new JavaProperties((InputStream)new ByteArrayInputStream(theBytes));
            }
            catch (ParseException e2) {
                try {
                    eProperties = new YamlProperties((InputStream)new ByteArrayInputStream(theBytes));
                }
                catch (ParseException e3) {
                    try {
                        eProperties = new JsonProperties((InputStream)new ByteArrayInputStream(theBytes));
                    }
                    catch (ParseException e4) {
                        throw new ParseException("Cannot parse the properties from the given input stream!", 0);
                    }
                }
            }
        }
        this._resourceProperties.add((ResourceProperties)eProperties);
        this._propertiesPrecedence.appendProperties((Properties)new ObfuscationPropertiesDecorator((Properties)eProperties, this.toDecrypted(this._secret)));
    }

    protected void addProperties(String aFilePath) throws IOException, ParseException {
        TomlPropertiesBuilder eProperties = null;
        try {
            eProperties = new TomlPropertiesBuilder(this.getClass(), aFilePath, true);
        }
        catch (ParseException e1) {
            try {
                eProperties = new JavaPropertiesBuilder(this.getClass(), aFilePath, true);
            }
            catch (ParseException e2) {
                try {
                    eProperties = new YamlPropertiesBuilder(this.getClass(), aFilePath, true);
                }
                catch (ParseException e3) {
                    try {
                        eProperties = new JsonPropertiesBuilder(this.getClass(), aFilePath, true);
                    }
                    catch (ParseException e) {
                        throw new ParseException("Cannot parse the properties from the given input stream!", 0);
                    }
                }
            }
        }
        try {
            eProperties = new ObfuscationResourcePropertiesBuilderDecorator((ResourceProperties.ResourcePropertiesBuilder)eProperties, this.toDecrypted(this._secret));
        }
        catch (OpenException openException) {
            // empty catch block
        }
        this._resourceProperties.add((ResourceProperties)eProperties);
        this._propertiesPrecedence.appendProperties((Properties)new ObfuscationPropertiesDecorator((Properties)eProperties, this.toDecrypted(this._secret)));
    }

    protected void addProperties(URL aUrl) throws IOException, ParseException {
        TomlProperties eProperties = null;
        try {
            eProperties = new TomlProperties(aUrl);
        }
        catch (ParseException e1) {
            try {
                eProperties = new JavaProperties(aUrl);
            }
            catch (ParseException e2) {
                try {
                    eProperties = new YamlProperties(aUrl);
                }
                catch (ParseException e3) {
                    try {
                        eProperties = new JsonProperties(aUrl);
                    }
                    catch (ParseException e4) {
                        throw new ParseException("Cannot parse the properties from the given input stream!", 0);
                    }
                }
            }
        }
        this._resourceProperties.add((ResourceProperties)eProperties);
        this._propertiesPrecedence.appendProperties((Properties)new ObfuscationPropertiesDecorator((Properties)eProperties, this.toDecrypted(this._secret)));
    }
}

