/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.connection.impls;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.component.OpenException;
import org.refcodes.connection.LoopbackReceiver;
import org.refcodes.connection.LoopbackSender;
import org.refcodes.connection.LoopbackTransceiver;
import org.refcodes.connection.impls.LoopbackReceiverImpl;
import org.refcodes.connection.impls.LoopbackSenderImpl;
import org.refcodes.connection.impls.LoopbackTransceiverImpl;

public class LoopbackConnectionTest {
    private static Logger LOGGER = Logger.getLogger(LoopbackConnectionTest.class);
    private static final String DATAGRAM_A = "Datagram A";
    private static final String DATAGRAM_B = "Datagram B";

    @Test
    public void testLoopbackTransceiver() throws OpenException, InterruptedException {
        for (int i = 0; i < 2; ++i) {
            LoopbackTransceiverImpl theLoopbackTransceiverA = new LoopbackTransceiverImpl();
            LoopbackTransceiverImpl theLoopbackTransceiverB = new LoopbackTransceiverImpl();
            theLoopbackTransceiverA.open((LoopbackTransceiver)theLoopbackTransceiverB);
            theLoopbackTransceiverB.open((LoopbackTransceiver)theLoopbackTransceiverA);
            theLoopbackTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
            String theDatagramA = (String)((Object)theLoopbackTransceiverB.readDatagram());
            LOGGER.info((Object)("Transceiver B read datagram \"" + theDatagramA + "\" from transceiver A."));
            Assert.assertEquals((Object)DATAGRAM_A, (Object)theDatagramA);
            theLoopbackTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_B));
            String theDatagramB = (String)((Object)theLoopbackTransceiverA.readDatagram());
            LOGGER.info((Object)("Transceiver A read datagram \"" + theDatagramB + "\" from transceiver B."));
            Assert.assertEquals((Object)DATAGRAM_B, (Object)theDatagramB);
            if (i == 0) {
                LOGGER.info((Object)"Closing transceiver A.");
                theLoopbackTransceiverA.close();
                Assert.assertTrue((boolean)theLoopbackTransceiverA.isClosed());
            }
            if (i == 1) {
                LOGGER.info((Object)"Closing transceiver B.");
                theLoopbackTransceiverB.close();
                Assert.assertTrue((boolean)theLoopbackTransceiverB.isClosed());
            }
            try {
                theLoopbackTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assert.fail();
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverA.readDatagram();
                Assert.fail();
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assert.fail();
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverB.readDatagram();
                Assert.fail();
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLoopbackSenderAndReceiver() throws OpenException, InterruptedException {
        for (int i = 0; i < 2; ++i) {
            LoopbackReceiverImpl theLoopbackReceiver = new LoopbackReceiverImpl();
            LoopbackSenderImpl theLoopbackSender = new LoopbackSenderImpl();
            theLoopbackReceiver.open((LoopbackSender)theLoopbackSender);
            theLoopbackSender.open((LoopbackReceiver)theLoopbackReceiver);
            theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
            theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_B));
            String theDatagram = (String)((Object)theLoopbackReceiver.readDatagram());
            LOGGER.info((Object)("Receiver read datagram \"" + theDatagram + "\" from sender."));
            Assert.assertEquals((Object)DATAGRAM_A, (Object)theDatagram);
            theDatagram = (String)((Object)theLoopbackReceiver.readDatagram());
            LOGGER.info((Object)("Receiver read datagram \"" + theDatagram + "\" from sender."));
            Assert.assertEquals((Object)DATAGRAM_B, (Object)theDatagram);
            if (i == 0) {
                LOGGER.info((Object)"Closing sender.");
                theLoopbackSender.close();
                Assert.assertTrue((boolean)theLoopbackSender.isClosed());
            }
            if (i == 1) {
                LOGGER.info((Object)"Closing receiver.");
                theLoopbackReceiver.close();
                Assert.assertTrue((boolean)theLoopbackReceiver.isClosed());
            }
            try {
                theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assert.fail();
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackReceiver.readDatagram();
                Assert.fail();
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }
}

