/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.collection.Relation;
import org.refcodes.collection.impls.RelationImpl;
import org.refcodes.console.ConsoleConsts;
import org.refcodes.console.Operand;
import org.refcodes.console.Option;
import org.refcodes.console.Switch;

public final class ConsoleUtility {
    private ConsoleUtility() {
    }

    public static boolean contains(String[] aArgs, String aArg) {
        ArrayList<String> theList = new ArrayList<String>(Arrays.asList(aArgs));
        return theList.contains(aArg);
    }

    public static boolean isOptionArgument(String aArg) {
        for (int i = 0; i < ConsoleConsts.OPTION_PREFIXES.length; ++i) {
            if (!aArg.startsWith(ConsoleConsts.OPTION_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }

    public static Relation<String, String> getOptionArgument(Option<?> aOption, String[] args) {
        if (args.length < 2) {
            return null;
        }
        Relation<String, String> theAttribute = ConsoleUtility.getOptionArgument(args, aOption.getShortOption());
        if (theAttribute != null) {
            return theAttribute;
        }
        theAttribute = ConsoleUtility.getOptionArgument(args, aOption.getLongOption());
        if (theAttribute != null) {
            return theAttribute;
        }
        return null;
    }

    @SafeVarargs
    public static String[] toArgs(List<? extends Operand<?>> ... aOperands) {
        ArrayList<String> theArgs = new ArrayList<String>();
        for (List<Operand<?>> list : aOperands) {
            for (Operand<?> eOperand : list) {
                theArgs.addAll(Arrays.asList(eOperand.getArgs()));
            }
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public static String[] toDiff(String[] aSet, String[] aSubset) {
        ArrayList<String> theDiff = new ArrayList<String>(Arrays.asList(aSet));
        for (String eSubset : aSubset) {
            theDiff.remove(eSubset);
        }
        return theDiff.toArray(new String[theDiff.size()]);
    }

    public static String[] toDiff(String[] aSet, List<? extends Operand<?>> aSubset) {
        String[] theSubset = ConsoleUtility.toArgs(aSubset);
        return ConsoleUtility.toDiff(aSet, theSubset);
    }

    public static String toParameterSpec(Operand<?> aOperand) {
        if (aOperand.getParameterName() == null) {
            return "";
        }
        StringBuilder theBuilder = new StringBuilder();
        if (!(aOperand instanceof Switch) && aOperand.getParameterName() != null) {
            if (aOperand instanceof Option) {
                theBuilder.append('<');
            }
            theBuilder.append(aOperand.getParameterName());
            if (aOperand instanceof Option) {
                theBuilder.append('>');
            }
        }
        return theBuilder.toString();
    }

    public static String toOptionsSpec(Operand<?> aOperand) {
        StringBuilder theBuilder = new StringBuilder();
        if (aOperand instanceof Option) {
            Option eOption = (Option)aOperand;
            if (eOption.getShortOption() != null) {
                theBuilder.append(eOption.getShortOption());
            }
            if (eOption.getLongOption() != null) {
                if (theBuilder.length() > 0) {
                    theBuilder.append(' ');
                }
                theBuilder.append(eOption.getLongOption());
            }
        }
        return theBuilder.toString();
    }

    public static String toSpec(Operand<?> aOperand) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(ConsoleUtility.toOptionsSpec(aOperand));
        String theParameterSpec = ConsoleUtility.toParameterSpec(aOperand);
        if (theParameterSpec != null && theParameterSpec.length() != 0 && theBuilder.length() > 0) {
            theBuilder.append(' ');
        }
        theBuilder.append(theParameterSpec);
        return theBuilder.toString();
    }

    private static Relation<String, String> getOptionArgument(String[] args, String eOption) {
        for (int i = 0; i < args.length - 1; ++i) {
            String eArg = args[i];
            if (!eArg.equals(eOption)) continue;
            String eOptArg = args[i + 1];
            for (String ePrefix : ConsoleConsts.OPTION_PREFIXES) {
                if (!eOptArg.startsWith(ePrefix)) continue;
                return null;
            }
            return new RelationImpl((Object)eOption, (Object)eOptArg);
        }
        return null;
    }
}

