/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.console.Condition;
import org.refcodes.console.Operand;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.impls.AbstractSyntaxable;

public abstract class AbstractCondition
extends AbstractSyntaxable
implements Condition {
    private List<Syntaxable> _children = new ArrayList<Syntaxable>();

    public AbstractCondition(Syntaxable ... aElements) {
        this._children.addAll(Arrays.asList(aElements));
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation) {
        StringBuilder theBuilder = new StringBuilder(this.parseSyntax(aSyntaxNotation));
        if (theBuilder.length() > 0) {
            theBuilder.insert(0, "( ");
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }

    public void reset() {
        for (Syntaxable eSyntaxable : this._children) {
            eSyntaxable.reset();
        }
    }

    public String toString() {
        String theState = this.toState();
        if (theState != null && theState.length() >= 4 && theState.startsWith("( ") && theState.endsWith(" )")) {
            theState = theState.substring(2).substring(0, theState.length() - 4);
        }
        return theState;
    }

    @Override
    public List<? extends Operand<?>> toOperands() {
        ArrayList<Operand<Object>> theList = new ArrayList<Operand<Object>>();
        for (Syntaxable eSyntaxable : this.getChildren()) {
            if (eSyntaxable instanceof Operand) {
                theList.add((Operand)eSyntaxable);
            }
            if (!(eSyntaxable instanceof Condition)) continue;
            theList.addAll(((Condition)eSyntaxable).toOperands());
        }
        return theList;
    }

    protected List<Syntaxable> getChildren() {
        return this._children;
    }

    protected void addChild(Syntaxable aArgumentizer) {
        this._children.add(aArgumentizer);
    }
}

