/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.ConsoleConsts;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.Option;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.impls.AbstractSyntaxable;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public abstract class AbstractOperand<T>
extends AbstractSyntaxable
implements Operand<T> {
    private Class<T> _type;
    private String _parameterName;
    private String _description;
    private T _value = null;
    private String[] _args = null;

    public AbstractOperand(Class<T> aType, String aParameterName, String aDescription) {
        this._type = aType;
        this._parameterName = aParameterName;
        this._description = aDescription;
    }

    public List<Operand<T>> parseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        int first = -1;
        for (int i = aArgs.length - 1; i >= 0; --i) {
            if (ConsoleUtility.isOptionArgument(aArgs[i]) || first != -1 && first + -1 != i) continue;
            first = i;
        }
        if (first != -1) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setValue(this.toValue(aArgs[first]));
            this.setArgs(new String[]{aArgs[first]});
            return theList;
        }
        throw new UnknownArgsException(aArgs, "Unable to determine an operand (not being prefixed with " + new VerboseTextBuilderImpl().withElements((Object[])ConsoleConsts.OPTION_PREFIXES).toString() + ").");
    }

    public String getDescription() {
        return this._description;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation) {
        return ConsoleUtility.toParameterSpec(this);
    }

    @Override
    public String getParameterName() {
        return this._parameterName;
    }

    public Class<?> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public String[] getArgs() {
        return this._args;
    }

    public void reset() {
        this._args = null;
        this._value = null;
    }

    @Override
    public String toState() {
        if (this._value != null) {
            StringBuilder theBuilder = new StringBuilder();
            if (this.getValue() instanceof String) {
                theBuilder.append('\"');
            }
            theBuilder.append(this._value.toString());
            if (this.getValue() instanceof String) {
                theBuilder.append('\"');
            }
            return theBuilder.toString();
        }
        return "null";
    }

    public String toString() {
        return this.toState();
    }

    @Override
    public int compareTo(Operand<?> obj) {
        if (obj instanceof Option) {
            if (this instanceof Option) {
                String otherOption = ((Option)obj).getShortOption() != null ? ((Option)obj).getShortOption() : ((Option)obj).getLongOption();
                String thisOption = ((Option)((Object)this)).getShortOption() != null ? ((Option)((Object)this)).getShortOption() : ((Option)((Object)this)).getLongOption();
                return thisOption.compareTo(otherOption);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (obj instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getParameterName() != null && obj.getParameterName() != null) {
            return this.getParameterName().compareTo(obj.getParameterName());
        }
        return this.toSyntax(null).compareTo(obj.toSyntax(null));
    }

    protected void setValue(T aValue) {
        this._value = aValue;
    }

    protected void setArgs(String[] aArgs) {
        this._args = aArgs;
    }

    protected abstract T toValue(String var1) throws ParseArgsException;
}

