/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.collection.Relation;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.Option;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.impls.AbstractOperand;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private String _shortOption;
    private String _longOption;

    public AbstractOption(String aShortOption, String aLongOption, Class<T> aType, String aOptionArgName, String aDescription) {
        super(aType, aOptionArgName, aDescription);
        if (aShortOption != null && (!aShortOption.startsWith("-") || aShortOption.startsWith("--"))) {
            throw new IllegalArgumentException("Your short-option \"" + aShortOption + "\" must start exactly with \"" + "-" + "\".");
        }
        if (aLongOption != null && !aLongOption.startsWith("--")) {
            throw new IllegalArgumentException("Your long-option \"" + aLongOption + "\" must start exactly with \"" + "-" + "\".");
        }
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    protected AbstractOption(String aShortOption, String aLongOption, Class<T> aType, String aDescription) {
        super(aType, null, aDescription);
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    @Override
    public List<Operand<T>> parseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        Relation<String, String> theOptionArgument = ConsoleUtility.getOptionArgument(this, aArgs);
        if (theOptionArgument != null) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setArgs(new String[]{(String)theOptionArgument.getKey(), (String)theOptionArgument.getValue()});
            this.setValue(this.toValue((String)theOptionArgument.getValue()));
            return theList;
        }
        if (ConsoleUtility.contains(aArgs, this.getShortOption())) {
            throw new ParseArgsException(aArgs, "Missing value; the short-option \"" + this.getShortOption() + "\" requires a value.");
        }
        if (ConsoleUtility.contains(aArgs, this.getLongOption())) {
            throw new ParseArgsException(aArgs, "Missing value; the long-option \"" + this.getLongOption() + "\" requires a value.");
        }
        throw new UnknownArgsException(aArgs, "Neither the short-option \"" + this.getShortOption() + "\" nor the long-option \"" + this.getLongOption() + "\"  was found in the command line arguments; at least one of them must be secified.");
    }

    @Override
    public String getShortOption() {
        return this._shortOption;
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation) {
        return (this.getShortOption() != null ? this.getShortOption() : this.getLongOption()) + (this.getParameterName() != null ? " " + ConsoleUtility.toParameterSpec(this) : "");
    }

    @Override
    public String toState() {
        String theSwitch = null;
        if (this.getShortOption() != null) {
            theSwitch = this.getShortOption();
        } else if (this.getLongOption() != null) {
            theSwitch = this.getLongOption();
            return theSwitch;
        }
        if (theSwitch != null) {
            StringBuilder theBuilder = new StringBuilder();
            theBuilder.append(theSwitch);
            theBuilder.append(":=");
            if (this.getValue() != null) {
                if (this.getValue() instanceof String) {
                    theBuilder.append('\"');
                }
                theBuilder.append(this.getValue().toString());
                if (this.getValue() instanceof String) {
                    theBuilder.append('\"');
                }
            } else {
                theBuilder.append("null");
            }
            return theBuilder.toString();
        }
        return "null";
    }

    @Override
    protected void setValue(T aValue) {
        super.setValue(aValue);
    }

    @Override
    protected void setArgs(String[] aArgs) {
        super.setArgs(aArgs);
    }
}

