/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.Condition;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.impls.AbstractCondition;

public class AndConditionImpl
extends AbstractCondition
implements Condition {
    private static final char GUN_POSIX_AND = ' ';
    private static final String LOGICAL_AND = " & ";

    public AndConditionImpl(Syntaxable ... aArgumentizers) {
        super(aArgumentizers);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList theResult = new ArrayList();
        for (Syntaxable e : this.getChildren()) {
            List<? extends Operand<?>> eOperands;
            try {
                eOperands = e.parseArgs(aArgs);
            }
            catch (UnknownArgsException exc) {
                throw new UnknownArgsException(exc.getArgs(), "At least one AND operand (option ) did not matched the provided command line arguments; though allmust match.", (Throwable)((Object)exc));
            }
            catch (AmbiguousArgsException exc) {
                throw new AmbiguousArgsException(exc.getArgs(), "At least one AND operand (option ) did not matched the provided command line arguments; though allmust match.", (Throwable)((Object)exc));
            }
            if (eOperands != null) {
                theResult.addAll(eOperands);
            }
            aArgs = ConsoleUtility.toDiff(aArgs, eOperands);
        }
        return theResult;
    }

    @Override
    public String parseSyntax(SyntaxNotation aSyntaxNotation) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_AND);
                } else {
                    theBuilder.append(' ');
                }
            }
            theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append("( ");
            } else {
                theBuilder.append(LOGICAL_AND);
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }
}

