/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.ArgsParser;
import org.refcodes.console.Condition;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.data.AsciiColorPaletteConsts;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.impls.AsciiArtBuilderImpl;
import org.refcodes.textual.impls.FontImpl;
import org.refcodes.textual.impls.HorizAlignTextBuilderImpl;
import org.refcodes.textual.impls.TableBuilderImpl;
import org.refcodes.textual.impls.TextBlockBuilderImpl;
import org.refcodes.textual.impls.TextBorderBuilderImpl;
import org.refcodes.textual.impls.TextLineBuilderImpl;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class ArgsParserImpl
implements ArgsParser {
    private Font _bannerFont = new FontImpl(FontType.DIALOG, FontStyle.PLAIN, 12);
    private char[] _bannerFontPalette = AsciiColorPaletteConsts.HALFTONE_GRAY;
    private char _separatorChar = (char)45;
    private Condition _rootCondition;
    private SyntaxNotation _syntaxNotation = SyntaxNotation.REFCODES;
    private PrintStream _standardOut = System.out;
    private int _consoleWidth;
    private int _maxConsoleWidth = -1;
    private String _lineBreak = SystemUtility.getLineBreak();
    private String _title = null;
    private String _name = "foobar";
    private String _description = "See the syntax declaration for usage, see the descriptions for the short- and the long-options. Option arguments are noted in angle brackets.";
    private String _usageLabel = "Usage";
    private String _licenseNote = "Licensed under GNU General Public License, v3.0 and Apache License, v2.0";
    private String _copyrightNote = "Copyright (c) by REFCODES.ORG, Munich, Germany.";
    private PrintStream _errorOut = System.err;

    public ArgsParserImpl(Condition aRootCondition) {
        this._rootCondition = aRootCondition;
        this.setConsoleWidth(SystemUtility.getConsoleWidth());
    }

    @Override
    public void setSyntaxNotation(SyntaxNotation aSyntaxNotation) {
        this._syntaxNotation = aSyntaxNotation;
    }

    @Override
    public void setStandardOut(PrintStream aStandardOut) {
        this._standardOut = aStandardOut;
    }

    @Override
    public void setErrorOut(PrintStream aErrorOut) {
        this._errorOut = aErrorOut;
    }

    @Override
    public void setConsoleWidth(int aConsoleWidth) {
        if (aConsoleWidth == -1 && (aConsoleWidth = SystemUtility.getConsoleWidth()) < 160) {
            aConsoleWidth = 160;
        }
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < aConsoleWidth ? this._maxConsoleWidth : aConsoleWidth) : aConsoleWidth;
    }

    @Override
    public void setLineBreak(String aLineBreak) {
        if (aLineBreak == null) {
            aLineBreak = SystemUtility.getLineBreak();
        }
        this._lineBreak = aLineBreak;
    }

    public void setDescription(String aDescription) {
        this._description = aDescription;
    }

    public void setName(String aName) {
        this._name = aName;
    }

    @Override
    public void setLicenseNote(String aLicenseNote) {
        this._licenseNote = aLicenseNote;
    }

    @Override
    public void setUsageLabel(String aUsageLabel) {
        this._usageLabel = aUsageLabel;
    }

    @Override
    public void setCopyrightNote(String aCopyrightNote) {
        this._copyrightNote = aCopyrightNote;
    }

    @Override
    public void setSeparatorChar(char aSeparatorChar) {
        this._separatorChar = aSeparatorChar;
    }

    @Override
    public void setBannerFont(Font aBannerFont) {
        this._bannerFont = aBannerFont;
    }

    @Override
    public void setBannerFontPalette(char[] aColorPalette) {
        this._bannerFontPalette = aColorPalette;
    }

    public void setTitle(String aTitle) {
        this._title = aTitle;
    }

    @Override
    public void setMaxConsoleWidth(int aMaxConsoleWidth) {
        this._maxConsoleWidth = aMaxConsoleWidth;
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < this._consoleWidth ? this._maxConsoleWidth : this._consoleWidth) : this._consoleWidth;
    }

    @Override
    public void printLicenseNote() {
        String[] theLines = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{this._licenseNote})).withColumnWidth(this._consoleWidth)).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        theLines = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theLines)).withColumnWidth(this._consoleWidth)).withFillChar(' ').toStrings();
        this._standardOut.println(ArgsParserImpl.fromTextBlock(theLines, this._lineBreak));
    }

    @Override
    public void printCopyrightNote() {
        String[] theLines = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{this._copyrightNote})).withColumnWidth(this._consoleWidth)).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        theLines = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theLines)).withColumnWidth(this._consoleWidth)).withFillChar(' ').toStrings();
        this._standardOut.println(ArgsParserImpl.fromTextBlock(theLines, this._lineBreak));
    }

    @Override
    public List<? extends Operand<?>> evalArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        List<? extends Operand<?>> theOperands = this._rootCondition.parseArgs(aArgs);
        Object[] theSuperflousArgs = ConsoleUtility.toDiff(aArgs, theOperands);
        if (theSuperflousArgs != null && theSuperflousArgs.length > 0) {
            throw new SuperfluousArgsException((String[])theSuperflousArgs, "Superflous command arguments " + new VerboseTextBuilderImpl().withElements(theSuperflousArgs).toString() + " were provided but not evaluatable (supported).");
        }
        return theOperands;
    }

    @Override
    public void printHelp() {
        this.printBanner();
        this.printLicenseNote();
        this.printSeparatorLn();
        this.printUsage();
        this.printSeparatorLn();
        this.printDescription();
        this.printSeparatorLn();
        this.printOptions();
        this.printSeparatorLn();
        this.printCopyrightNote();
        this.printSeparatorLn();
    }

    @Override
    public void printUsage() {
        String theSyntax = this._usageLabel + ": " + this._name + " " + this._rootCondition.parseSyntax(this._syntaxNotation);
        this._standardOut.println(theSyntax);
    }

    @Override
    public void printDescription() {
        String[] theLines = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{this._description})).withColumnWidth(this._consoleWidth)).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._standardOut.println(ArgsParserImpl.fromTextBlock(theLines, this._lineBreak));
    }

    @Override
    public void printLn(String aLine) {
        String[] theLines = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth)).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._standardOut.println(ArgsParserImpl.fromTextBlock(theLines, this._lineBreak));
    }

    @Override
    public void errorLn(String aLine) {
        String[] theLines = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth)).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._errorOut.println(ArgsParserImpl.fromTextBlock(theLines, this._lineBreak));
    }

    @Override
    public void printLn() {
        this._standardOut.println();
    }

    @Override
    public void printSeparatorLn() {
        this._standardOut.println(new TextLineBuilderImpl().withColumnWidth(this._consoleWidth).withLineChar(this._separatorChar).toString());
    }

    @Override
    public void printBanner() {
        int theBannerWidth = this._consoleWidth - 4;
        String[] theCanvas = ((AsciiArtBuilder)((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont)).withAsciiColors(this._bannerFontPalette).withColumnWidth(theBannerWidth)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        theCanvas = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theCanvas)).withColumnWidth(theBannerWidth)).withFillChar(' ').toStrings();
        theCanvas = ((TextBorderBuilder)new TextBorderBuilderImpl().withBoxBorderMode(BoxBorderMode.ALL).withText(theCanvas)).withBorderWidth(1).withBorderChar(' ').toStrings();
        theCanvas = ((TextBorderBuilder)((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(theCanvas)).withTableStyle(TableStyle.DOUBLE)).withBoxBorderMode(BoxBorderMode.ALL)).toStrings();
        String theBanner = ArgsParserImpl.fromTextBlock(theCanvas, this._lineBreak);
        this._standardOut.println(theBanner);
    }

    @Override
    public void printOptions() {
        List<Operand<?>> theOperands = this._rootCondition.toOperands();
        ArrayList<String[]> theOptArgs = new ArrayList<String[]>();
        int theMaxLength = 0;
        for (Operand<?> eOperand : theOperands) {
            String eOpt = ConsoleUtility.toSpec(eOperand) + ":";
            theOptArgs.add(new String[]{eOpt, eOperand.getDescription()});
            if (eOpt.length() <= theMaxLength) continue;
            theMaxLength = eOpt.length();
        }
        TableBuilder theOptTable = ((TableBuilder)new TableBuilderImpl().withTableStyle(TableStyle.BLANK).withRowWidth(this._consoleWidth)).withPrintStream(this._standardOut);
        theOptTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(theMaxLength, ColumnWidthType.ABSOLUTE).withLeftBorder(false).withRightBorder(false);
        theOptTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withLeftBorder(false).withRightBorder(false).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
        for (String[] eOptArg : theOptArgs) {
            theOptTable.printRowContinue(eOptArg);
        }
    }

    @Override
    public Condition getRootCondition() {
        return this._rootCondition;
    }

    public void reset() {
        if (this._rootCondition != null) {
            this._rootCondition.reset();
        }
    }

    private static String fromTextBlock(String[] aTextBlock, String aDelimeter) {
        StringBuilder theBuilder = new StringBuilder();
        for (String eString : aTextBlock) {
            if (aDelimeter != null && aDelimeter.length() != 0 && theBuilder.length() > 0) {
                theBuilder.append(aDelimeter);
            }
            theBuilder.append(eString);
        }
        return theBuilder.toString();
    }
}

