/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.Condition;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.impls.AbstractCondition;

public class OrConditionImpl
extends AbstractCondition
implements Condition {
    private static final String GNU_POSIX_OR = " ? ";
    private static final String LOGICAL_OR = " | ";

    public OrConditionImpl(Syntaxable ... aArgumentizers) {
        super(aArgumentizers);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList theResult = null;
        for (Syntaxable e : this.getChildren()) {
            try {
                List<? extends Operand<?>> eOperands = e.parseArgs(aArgs);
                if (eOperands != null) {
                    if (theResult == null) {
                        theResult = new ArrayList();
                    }
                    theResult.addAll(eOperands);
                }
                aArgs = ConsoleUtility.toDiff(aArgs, eOperands);
            }
            catch (AmbiguousArgsException | UnknownArgsException argsMismatchException) {}
        }
        if (theResult != null) {
            return theResult;
        }
        throw new UnknownArgsException(aArgs, "None OR operand (option) matched the provided command line arguments; though at least one must match.");
    }

    @Override
    public String parseSyntax(SyntaxNotation aSyntaxNotation) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_OR);
                } else {
                    theBuilder.append(GNU_POSIX_OR);
                }
            }
            theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append("( ");
            } else {
                theBuilder.append(LOGICAL_OR);
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }
}

