/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console.impls;

import java.util.List;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.Condition;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.impls.AbstractCondition;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class XorConditionImpl
extends AbstractCondition
implements Condition {
    private static final String GUN_POSIX_XOR = " | ";
    private static final String LOGICAL_XOR = " ^ ";

    public XorConditionImpl(Syntaxable ... aArgumentizers) {
        super(aArgumentizers);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        List<Operand<?>> theResult = null;
        for (Syntaxable e : this.getChildren()) {
            List<Operand<?>> eOperands = null;
            try {
                eOperands = e.parseArgs(aArgs);
                if (eOperands != null && eOperands.isEmpty()) {
                    eOperands = null;
                }
            }
            catch (AmbiguousArgsException | UnknownArgsException argsMismatchException) {
                // empty catch block
            }
            if (theResult != null && eOperands != null) {
                throw new AmbiguousArgsException(aArgs, "More than one XOR operand (option) matched the provided command line arguments; though exactly one must match: " + new VerboseTextBuilderImpl().withElements((Object[])ConsoleUtility.toArgs(theResult, eOperands)).toString());
            }
            if (eOperands == null || eOperands.isEmpty() || theResult != null) continue;
            theResult = eOperands;
        }
        if (theResult != null) {
            return theResult;
        }
        throw new UnknownArgsException(aArgs, "Not one XOR operand (option) matched the provided command line arguments; though exactly one must match.");
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation) {
        StringBuilder theBuilder = new StringBuilder(this.parseSyntax(aSyntaxNotation));
        if (theBuilder.length() > 0) {
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.insert(0, "( ");
            } else {
                theBuilder.insert(0, "{ ");
            }
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.append(" )");
            } else {
                theBuilder.append(" }");
            }
        }
        return theBuilder.toString();
    }

    @Override
    public String parseSyntax(SyntaxNotation aSyntaxNotation) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_XOR);
                } else {
                    theBuilder.append(GUN_POSIX_XOR);
                }
            }
            theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append("( ");
            } else {
                theBuilder.append(LOGICAL_XOR);
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }
}

