// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console;

/**
 * Provides an accessor for a command line arguments (short "args") array.
 */
public interface ArgsAccessor {

	/**
	 * Retrieves the command line arguments from the args property.
	 * 
	 * @return The command line arguments stored by the args property.
	 */
	String[] getArgs();

	/**
	 * Provides a mutator for a args property.
	 * 
	 * @param <String[]> The consoleTask's type to be accessed.
	 */
	public interface ArgsMutator {

		/**
		 * Sets the command line arguments for the args property.
		 * 
		 * @param aConsoleTask The command line arguments to be stored by the
		 *        args property.
		 */
		void setArgs( String[] aConsoleTask );
	}

	/**
	 * Provides a args property.
	 */
	public interface ArgsProperty extends ArgsAccessor, ArgsMutator {}
}
