// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console;

import java.util.List;

/**
 * The {@link Condition} interface represents a node in the command line
 * arguments syntax tree; simply extending the {@link Syntaxable} interface and
 * adding the functionality of providing access to the added {@link Operand}s
 * (leafs). In future extensions, a {@link Condition} might provide access to
 * the child {@link Syntaxable} elements contained in a {@link Condition}
 * instance. As of the current findings, access to the children of the
 * {@link Condition} node is not required and would make the interface
 * unnecessarily complicated.
 */
public interface Condition extends Syntaxable {

	/**
	 * Traverses the hierarchy of {@link Condition}s and collects all therein
	 * found {@link Operand}s and sub-types such as the {@link Switch} or the
	 * {@link Option}. This is most useful when creating a list of
	 * {@link Option}s, {@link Switch}es and {@link Operand}s when printing out
	 * detailed help.
	 * 
	 * @return The according {@link Operand} elements.
	 */
	List<? extends Operand<?>> toOperands();

}
