// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console;

import org.refcodes.exception.AbstractException;
import org.refcodes.mixin.StatusCodeAccessor;

/**
 * Base exception for the console artifact.
 *
 * @author steiner
 */
public abstract class ConsoleException extends AbstractException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ConsoleException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	public ConsoleException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	public ConsoleException( String message, Throwable cause ) {
		super( message, cause );
	}

	public ConsoleException( String message ) {
		super( message );
	}

	public ConsoleException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	public ConsoleException( Throwable cause ) {
		super( cause );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	public static abstract class ConsoleCliException extends ConsoleException implements StatusCodeAccessor<ExitCode> {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private ExitCode _exitCode;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////


		public ConsoleCliException( ExitCode aExitCode, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_exitCode = aExitCode;
		}


		public ConsoleCliException( ExitCode aExitCode, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_exitCode = aExitCode;
		}


		public ConsoleCliException( ExitCode aExitCode, String message, Throwable cause ) {
			super( message, cause );
			_exitCode = aExitCode;
		}


		public ConsoleCliException( ExitCode aExitCode, String message ) {
			super( message );
			_exitCode = aExitCode;
		}


		public ConsoleCliException( ExitCode aExitCode, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_exitCode = aExitCode;
		}


		public ConsoleCliException( ExitCode aExitCode, Throwable cause ) {
			super( cause );
			_exitCode = aExitCode;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		@Override
		public ExitCode getStatusCode() {
			return _exitCode;
		}
	}

	/**
	 * This abstract exception is the base exception for all command line
	 * argument related exceptions.
	 * 
	 * @author steiner
	 */
	public static abstract class ConsoleArgsException extends ConsoleException implements ArgsAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////

		private String[] _args;

		// /////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////


		public ConsoleArgsException( String[] aArgs, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_args = aArgs;
		}


		public ConsoleArgsException( String[] aArgs, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_args = aArgs;
		}


		public ConsoleArgsException( String[] aArgs, String message, Throwable cause ) {
			super( message, cause );
			_args = aArgs;
		}


		public ConsoleArgsException( String[] aArgs, String message ) {
			super( message );
			_args = aArgs;
		}


		public ConsoleArgsException( String[] aArgs, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_args = aArgs;
		}


		public ConsoleArgsException( String[] aArgs, Throwable cause ) {
			super( cause );
			_args = aArgs;
		}

		// /////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////

		@Override
		public String[] getArgs() {
			return _args;
		}
	}
}
