// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console;

import org.refcodes.console.impls.AndConditionImpl;
import org.refcodes.console.impls.EnumOptionImpl;
import org.refcodes.console.impls.ForceSwitchImpl;
import org.refcodes.console.impls.HelpSwitchImpl;
import org.refcodes.console.impls.IntegerOptionImpl;
import org.refcodes.console.impls.OptionalConditionImpl;
import org.refcodes.console.impls.OrConditionImpl;
import org.refcodes.console.impls.QuietSwitchImpl;
import org.refcodes.console.impls.StringOperandImpl;
import org.refcodes.console.impls.StringOptionImpl;
import org.refcodes.console.impls.SwitchImpl;
import org.refcodes.console.impls.SysInfoSwitchImpl;
import org.refcodes.console.impls.VerboseSwitchImpl;
import org.refcodes.console.impls.XorConditionImpl;

/**
 * Declarative syntactic sugar which may be statically imported in order to
 * allow declarative definitions for the command line {@link Switch},
 * {@link Condition}, {@link Option} and {@link Operand} elements.
 */
public class ConsoleSugar {

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * @see AndConditionImpl
	 */
	public static Condition and( Syntaxable... aArgs ) {
		return new AndConditionImpl( aArgs );
	}

	/**
	 * @see OrConditionImpl
	 */
	public static Condition or( Syntaxable... aArgs ) {
		return new OrConditionImpl( aArgs );
	}

	/**
	 * @see XorConditionImpl
	 */
	public static Condition xor( Syntaxable... aArgs ) {
		return new XorConditionImpl( aArgs );
	}

	/**
	 * @see OptionalConditionImpl
	 */
	public static Condition optional( Syntaxable... aArg ) {
		return new OptionalConditionImpl( aArg );
	}

	/**
	 * @see EnumOptionImpl
	 */
	public static <T extends Enum<T>> Option<T> enumOption( String aShortOption, String aLongOption, Class<T> aType, String aOptionArgName, String aDescription ) {
		return new EnumOptionImpl<T>( aShortOption, aLongOption, aType, aOptionArgName, aDescription );
	}

	/**
	 * As "switch" is a reserved word in Java, we use "switsh" :-(
	 * 
	 * @see Switch
	 */
	public static Switch switsh( String aShortOption, String aLongOption, String aDescription ) {
		return new SwitchImpl( aShortOption, aLongOption, aDescription );
	}

	/**
	 * @see ForceSwitchImpl
	 */
	public static Switch forcesSwitch( String aDescription ) {
		return new ForceSwitchImpl( aDescription );
	}

	/**
	 * @see ForceSwitchImpl
	 */
	public static Switch forcesSwitch() {
		return new ForceSwitchImpl();
	}

	/**
	 * @see HelpSwitchImpl
	 */
	public static Switch helpSwitch( String aDescription ) {
		return new HelpSwitchImpl( aDescription );
	}

	/**
	 * @see HelpSwitchImpl
	 */
	public static Switch helpSwitch() {
		return new HelpSwitchImpl();
	}

	/**
	 * @see SysInfoSwitchImpl
	 */
	public static Switch sysInfoSwitch( String aDescription ) {
		return new SysInfoSwitchImpl( aDescription );
	}

	/**
	 * @see SysInfoSwitchImpl
	 */
	public static Switch sysInfoSwitch() {
		return new SysInfoSwitchImpl();
	}

	/**
	 * @see QuietSwitchImpl
	 */
	public static Switch quietSwitch( String aDescription ) {
		return new QuietSwitchImpl( aDescription );
	}

	/**
	 * @see QuietSwitchImpl
	 */
	public static Switch quietSwitch() {
		return new QuietSwitchImpl();
	}

	/**
	 * @see VerboseSwitchImpl
	 */
	public static Switch verboseSwitch( String aDescription ) {
		return new VerboseSwitchImpl( aDescription );
	}

	/**
	 * @see VerboseSwitchImpl
	 */
	public static Switch verboseSwitch() {
		return new VerboseSwitchImpl();
	}

	/**
	 * @see IntegerOptionImpl
	 */
	public static Option<Integer> intOption( String aShortOption, String aLongOption, String aOptionArgName, String aDescription ) {
		return new IntegerOptionImpl( aShortOption, aLongOption, aOptionArgName, aDescription );
	}

	/**
	 * @see StringOptionImpl
	 */
	public static Option<String> stringOption( String aShortOption, String aLongOption, String aOptionArgName, String aDescription ) {
		return new StringOptionImpl( aShortOption, aLongOption, aOptionArgName, aDescription );
	}

	/**
	 * @see StringOperandImpl
	 */
	public static Operand<String> stringOperand( String aIdentifier, String aDescription ) {
		return new StringOperandImpl( aIdentifier, aDescription );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
