// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console;

import org.refcodes.data.Prefixes;

/**
 * An {@link Option} represents a command line option with the according
 * option's value. An {@link Option} can be seen as a key/value(s) pair
 * defined in the command line arguments parsed via the
 * {@link #parseArgs(String[])} method.
 * <p>
 * An {@link Option} has a state which changes with each invocation of the
 * {@link #parseArgs(String[])} method.
 */
public interface Option<T> extends Operand<T> {

	/**
	 * Returns the short-option representing an {@link Option} instance. A short
	 * option usually is being prefixed with a single hyphen-minus "-" as
	 * defined in {@link Prefixes#SHORT_OPTION_PREFIX}.
	 * 
	 * @return The short-option {@link String}.
	 */
	String getShortOption();

	/**
	 * TODO: Make the option to be required without the hyphen-minuses "--"
	 * 
	 * Returns the long-option representing an {@link Option} instance. A long
	 * option usually is being prefixed with a double hyphen-minus "--" as
	 * defined in {@link Prefixes#LONG_OPTION_PREFIX}.
	 * 
	 * @return The long-option {@link String}.
	 */
	String getLongOption();
}
