// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console.impls;

import org.refcodes.console.ParseArgsException;

/**
 * @author steiner
 *
 */
public class EnumOptionImpl<T extends Enum<T>> extends AbstractOption<T> {

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public EnumOptionImpl( String aShortOption, String aLongOption, Class<T> aType, String aOptionArgName, String aDescription ) {
		super( aShortOption, aLongOption, aType, aOptionArgName, aDescription );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	@SuppressWarnings("unchecked")
	@Override
	protected T toValue( String aArg ) throws ParseArgsException {
		IllegalArgumentException theFirstCause = null;
		try {
			return Enum.valueOf( (Class<T>) getType(), aArg );
		}
		catch ( IllegalArgumentException e1 ) {
			theFirstCause = e1;
			try {
				return Enum.valueOf( (Class<T>) getType(), aArg.toUpperCase() );
			}
			catch ( IllegalArgumentException e2 ) {
				try {
					return Enum.valueOf( (Class<T>) getType(), aArg.toLowerCase() );
				}
				catch ( IllegalArgumentException e3 ) {
					throw new ParseArgsException( new String[] {
							aArg
					}, "Invalid argument \"" + aArg + "\" for option <" + getParameterName() + ">.", theFirstCause );
				}
			}
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
