// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;

import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.ConsoleUtility;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;

/**
 * @author steiner
 *
 */
public class OptionalConditionImpl extends AbstractCondition {

	private static final String LEFT_TAG = "[ ";
	private static final String RIGHT_TAG = " ]";

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public OptionalConditionImpl( Syntaxable... aSyntaxable ) {
		super( aSyntaxable );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@SuppressWarnings("unchecked")
	@Override
	public List<? extends Operand<?>> parseArgs( String[] aArgs ) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
		List<Operand<?>> theResult = new ArrayList<Operand<?>>();
		List<Operand<?>> eOperands = null;
		for ( Syntaxable eChild : getChildren() ) {
			try {
				eOperands = (List<Operand<?>>) eChild.parseArgs( aArgs );
				if ( eOperands != null ) {
					theResult.addAll( (List<? extends Operand<?>>) eOperands );
				}
				aArgs = ConsoleUtility.toDiff( aArgs, eOperands );
			}
			catch ( UnknownArgsException ignore ) { /* optional! */ }
			// catch ( AmbiguousArgsException exc ) { /* optional! */ }
		}
		return theResult;
	}

	@Override
	public String parseSyntax( SyntaxNotation aSyntaxNotation ) {
		if ( getChildren() != null && getChildren().size() > 0 ) {
			StringBuilder theBuilder = new StringBuilder();
			for ( Syntaxable eArgumentizer : getChildren() ) {
				if ( theBuilder.length() != 0 ) {
					theBuilder.append( " " );
				}
				theBuilder.append( LEFT_TAG );
				theBuilder.append( eArgumentizer.toSyntax( aSyntaxNotation ) );
				theBuilder.append( RIGHT_TAG );
			}
			return theBuilder.toString();
		}
		return "";
	}

	@Override
	public String toState() {
		StringBuilder theBuilder = new StringBuilder();
		for ( Syntaxable eArgumentizer : getChildren() ) {
			if ( theBuilder.length() == 0 ) {
				theBuilder.append( LEFT_TAG );
			}
			else {
				theBuilder.append( " " );
			}
			theBuilder.append( eArgumentizer.toState() );
		}
		if ( theBuilder.length() != 0 ) {
			theBuilder.append( RIGHT_TAG );
		}
		return theBuilder.toString();
	}

	@Override
	public void reset() {
		getChildren().get( 0 ).reset();
	}

	@Override
	public String toString() {
		return toState();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
