// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.console.impls;

import java.util.ArrayList;
import java.util.List;

import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.Operand;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.Switch;
import org.refcodes.console.UnknownArgsException;

/**
 * @author steiner
 *
 */
public class SwitchImpl extends AbstractOption<Boolean> implements Switch {

	/**
	 * Constructs a {@link Switch}
	 * 
	 * @param aShortOption The short-option being a single character with the
	 *        additional single hyphen-minus "-" prefix.
	 * @param aLongOption The long-option being a multi-character sequence with
	 *        at least two characters with the additional double hyphen-minus
	 *        "--" prefix.
	 * @param aDescription A description without any line breaks.
	 */
	public SwitchImpl( String aShortOption, String aLongOption, String aDescription ) {
		super( aShortOption, aLongOption, Boolean.class, aDescription );
		setValue( false );
	}

	@Override
	public List<Operand<Boolean>> parseArgs( String[] aArgs ) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
		for ( String eArg : aArgs ) {
			String theOption = getShortOption();
			if ( eArg.equals( theOption ) ) {
				List<Operand<Boolean>> theList = new ArrayList<Operand<Boolean>>();
				theList.add( this );
				setValue( true );
				setArgs( new String[] {
					theOption
				} );
				return theList;
			}
			theOption = getLongOption();
			if ( eArg.equals( theOption ) ) {
				List<Operand<Boolean>> theList = new ArrayList<Operand<Boolean>>();
				theList.add( this );
				setValue( true );
				setArgs( new String[] {
					theOption
				} );
				return theList;
			}
		}
		throw new UnknownArgsException( aArgs, "Neither the short-option \"" + getShortOption() + "\" nor the long-option \"" + getLongOption() + "\"  was set in the command line arguments; at least one of them must be set." );
	}

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public void reset() {
		super.reset();
		super.setValue( false );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	protected Boolean toValue( String aArg ) throws ParseArgsException {
		throw new UnsupportedOperationException( "*** NOT REQUIRED BY THIS IMPLEMENTATION ***" );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
