/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.AndConditionImpl;
import org.refcodes.console.ArgsParser;
import org.refcodes.console.ArgsParserImpl;
import org.refcodes.console.Condition;
import org.refcodes.console.FlagImpl;
import org.refcodes.console.Operand;
import org.refcodes.console.OptionalConditionImpl;
import org.refcodes.console.OrConditionImpl;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.StringOperandImpl;
import org.refcodes.console.StringOptionImpl;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.XorConditionImpl;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.structure.PropertyImpl;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class ArgsParserTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String[][] ARGS = new String[][]{{"--name", "NAME", "--boolean", "--active"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "NAME", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "NAME", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=NAME", "boolean=true", "active=true"}, {"name=NAME", "boolean=true", "alias=ALIAS"}, {"name=NAME", "boolean=true", "alias=ALIAS", "active=true"}, {"name=NAME", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=NAME", "boolean=true", "alias=ALIAS"}, {"name=NAME", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testParser1() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser2() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        OptionalConditionImpl theOptional = new OptionalConditionImpl(new Syntaxable[]{theXor});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theOptional, theFile});
        String[] args = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        if (IS_LOG_TESTS) {
            System.out.println(theAnd.toUsage());
        }
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser3() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser4() throws AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser5() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser6() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser7() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser8() {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theDelete, theAdd});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theOperand, theXor, theFromFile, theToFile});
        List theList = theAnd.toOperands();
        Collections.sort(theList);
        this.doLogOperands(theList);
    }

    @Test
    public void testParser9() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        FlagImpl theAdd = new FlagImpl("-a", null, "Add the specified file");
        FlagImpl theCreate = new FlagImpl("-c", null, "Creates the specified file");
        OrConditionImpl theOrCondition = new OrConditionImpl(new Syntaxable[]{theAdd, theCreate});
        FlagImpl theDelete = new FlagImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theOrCondition, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to", "The destination file to be processed");
        FlagImpl theAddFile = new FlagImpl("-a", "--add", "add", "Add the specified file");
        FlagImpl theCreateFile = new FlagImpl("-c", "--create", "create", "Creates the specified file");
        OrConditionImpl theOrCondition = new OrConditionImpl(new Syntaxable[]{theAddFile, theCreateFile});
        FlagImpl theDeleteFile = new FlagImpl("-d", "--delete", "delete", "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theOrCondition, theDeleteFile});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        if (IS_LOG_TESTS) {
            System.out.println(theAnd.toUsage());
        }
        theArgsParser.evalArgs(args);
        String theFrom = (String)theAnd.get("from");
        String theTo = (String)theAnd.get("to");
        boolean theAdd = (Boolean)theAnd.get("add");
        boolean theCreate = (Boolean)theAnd.get("create");
        boolean theDelete = (Boolean)theAnd.get("delete");
        if (IS_LOG_TESTS) {
            System.out.println("From := " + theFrom);
        }
        if (IS_LOG_TESTS) {
            System.out.println("To := " + theTo);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Add := " + theAdd);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Create := " + theCreate);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Delete := " + theDelete);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)theFrom);
        Assertions.assertEquals((Object)"toFile", (Object)theTo);
        Assertions.assertTrue((boolean)theAdd);
        Assertions.assertFalse((boolean)theCreate);
        Assertions.assertFalse((boolean)theDelete);
    }

    @Test
    public void testArgsProperties() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Disabled
    @Test
    public void testEdgeCase() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        this.testArgs(3);
    }

    private void testArgs(int i) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        ArgsParserImpl theArgsParser = new ArgsParserImpl();
        HashMap<String, String> theProperties = new HashMap<String, String>();
        List theOperands = theArgsParser.evalArgs(ARGS[i]);
        for (Operand eOperand : theOperands) {
            theProperties.put(eOperand.getAlias(), "" + eOperand.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("Line <" + i + ">:");
        }
        for (String eKey : theProperties.keySet()) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(eKey + " := " + (String)theProperties.get(eKey));
        }
        String[] theExcepcted = PROPERTIES[i];
        for (int j = 0; j < theExcepcted.length; ++j) {
            PropertyImpl eProperty = new PropertyImpl(theExcepcted[j]);
            if (((String)eProperty.getKey()).equals("null")) {
                eProperty = new PropertyImpl(null, (String)eProperty.getValue());
            }
            Assertions.assertEquals((Object)eProperty.getValue(), theProperties.get(eProperty.getKey()), (String)("Line <" + i + "> (" + eProperty.toString() + ")"));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ArgsParser aArgsParser, String[] aArgs) {
        Condition theCondition = aArgsParser.getRootCondition();
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        aArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + theCondition.toUsage(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + theCondition.toUsage(SyntaxNotation.GNU_POSIX));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[COMMAND LINE ARGS]         " + new VerboseTextBuilderImpl().withElements((Object[])aArgs).toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("[INTERNAL STATUS]           " + theCondition.toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(List<? extends Operand<?>> aOperands) {
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> eOperand : aOperands) {
            if (!IS_LOG_TESTS) continue;
            System.out.println("[OPERAND] " + eOperand.toSyntax(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }
}

