/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow.impls;

import java.util.concurrent.atomic.AtomicInteger;
import org.refcodes.controlflow.ExceptionWatchdog;
import org.refcodes.controlflow.utils.ControlFlowUtility;

public class ExceptionWatchdogImpl<E extends Exception>
implements ExceptionWatchdog<E> {
    AtomicInteger _threadCount = new AtomicInteger(0);
    private E _exception = null;
    private E _lastException = null;
    boolean _isDisposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void catchException() throws E {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        ExceptionWatchdogImpl exceptionWatchdogImpl = this;
        synchronized (exceptionWatchdogImpl) {
            this.waitForExceptionHandling();
            this._threadCount.incrementAndGet();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        E theException = this._exception;
        this._threadCount.decrementAndGet();
        if (theException == null) {
            return;
        }
        if (this._threadCount.get() == 0) {
            this._exception = null;
        }
        throw theException;
    }

    @Override
    public E lastException() {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        return this._lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwException(E aException) {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        this._exception = aException;
        ExceptionWatchdogImpl exceptionWatchdogImpl = this;
        synchronized (exceptionWatchdogImpl) {
            this.notifyAll();
        }
        this.waitForExceptionHandling();
        this._lastException = aException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        this._exception = null;
        ExceptionWatchdogImpl exceptionWatchdogImpl = this;
        synchronized (exceptionWatchdogImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this._isDisposed = true;
        this._exception = null;
        ExceptionWatchdogImpl exceptionWatchdogImpl = this;
        synchronized (exceptionWatchdogImpl) {
            this.notifyAll();
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notifyAll();
        }
    }

    private void waitForExceptionHandling() {
        long theStartTime = System.currentTimeMillis();
        while (this._threadCount.get() > 0 && this._exception != null && System.currentTimeMillis() - theStartTime < 500L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

