/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow.impls;

import org.refcodes.controlflow.RetryTimeout;

public class RetryTimeoutImpl
implements RetryTimeout {
    private long _currentTimeInMs = -1L;
    private long _timeoutInMs;
    private long _retryDelayInMs;
    private int _retryCount = 0;

    public RetryTimeoutImpl(long aTimeoutInMs, long aRetryDelayInMs) {
        this._timeoutInMs = aTimeoutInMs;
        this._retryDelayInMs = aRetryDelayInMs;
    }

    @Override
    public boolean nextRetry() {
        return this.nextRetry(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextRetry(Object aMonitor) {
        if (this._currentTimeInMs == -1L) {
            this._currentTimeInMs = System.currentTimeMillis();
        }
        if (!this.hasNextRetry()) {
            return false;
        }
        Object object = aMonitor;
        synchronized (object) {
            try {
                aMonitor.wait(this._retryDelayInMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++this._retryCount;
        return true;
    }

    @Override
    public boolean hasNextRetry() {
        return this._currentTimeInMs == -1L || System.currentTimeMillis() < this._currentTimeInMs + this._timeoutInMs;
    }

    @Override
    public int getRetryCount() {
        return this._retryCount;
    }

    public void abort() {
        this._currentTimeInMs = System.currentTimeMillis() - (this._timeoutInMs + 1L);
    }

    public void restart() {
        this._retryCount = 0;
        this._currentTimeInMs = -1L;
    }

    @Override
    public long getTimeoutInMs() {
        return this._timeoutInMs;
    }

    @Override
    public long getRetryDelayInMs() {
        return this._retryDelayInMs;
    }
}

