/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow.utils;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.refcodes.controlflow.factories.ThreadFactoryImpl;
import org.refcodes.controlflow.impls.ManagedExecutorService;

public final class ControlFlowUtility {
    private ControlFlowUtility() {
    }

    public static void throwIllegalStateException(boolean isIllegalState) throws IllegalStateException {
        if (isIllegalState) {
            throw new IllegalStateException("Illegal state detected for invoking the operation; this instance's state does not allow this operation (it might be disposed, destroyed, decomposed, closed or similar).");
        }
    }

    public static void joinThreads(Collection<? extends Thread> aThreads) {
        for (Thread thread : aThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void joinThreads(Thread ... aThreads) {
        for (Thread eJoinThread : aThreads) {
            try {
                eJoinThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void joinFutures(Collection<? extends Future<?>> aFutures) {
        for (Future<?> eJoinFuture : aFutures) {
            try {
                eJoinFuture.get();
            }
            catch (Exception exception) {}
        }
    }

    public static void joinFutures(Future<?> ... aFutures) {
        for (Future<?> eJoinFuture : aFutures) {
            try {
                eJoinFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object waitForFutures(Collection<? extends Future<?>> aFutures) throws Exception {
        Exception theException = null;
        Object theResult = null;
        for (Future<?> eJoinFuture : aFutures) {
            try {
                if (theResult == null) {
                    theResult = eJoinFuture.get();
                    continue;
                }
                eJoinFuture.get();
            }
            catch (Exception e) {
                if (theException != null) continue;
                theException = e;
            }
        }
        if (theException != null) {
            throw theException;
        }
        return theResult;
    }

    public static Object waitForFutures(Future<?> ... aFutures) throws Exception {
        Exception theException = null;
        Object theResult = null;
        for (Future<?> eJoinFuture : aFutures) {
            try {
                if (theResult == null) {
                    theResult = eJoinFuture.get();
                    continue;
                }
                eJoinFuture.get();
            }
            catch (Exception e) {
                if (theException != null) continue;
                theException = e;
            }
        }
        if (theException != null) {
            throw theException;
        }
        return theResult;
    }

    public static void shutdownGracefully(ExecutorService aExecutorService) {
        ControlFlowUtility.shutdownGracefully(aExecutorService, 5000L);
    }

    public static void shutdownGracefully(ExecutorService aExecutorService, long aTimeOutInMs) {
        aExecutorService.shutdown();
        if (aTimeOutInMs > 0L) {
            try {
                aExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            aExecutorService.shutdownNow();
        }
    }

    public static ExecutorService toManagedExecutorService(ExecutorService aExecutorService) {
        if (aExecutorService instanceof ManagedExecutorService) {
            return aExecutorService;
        }
        return new ManagedExecutorService(aExecutorService);
    }

    public static ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool();
    }

    public static ExecutorService createDaemonExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(true));
    }
}

