/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.controlflow.ExceptionWatchdog;
import org.refcodes.controlflow.ExceptionWatchdogImpl;
import org.refcodes.controlflow.RetryCounterImpl;

public class ExceptionWatchdogTest {
    private static Logger LOGGER = Logger.getLogger(ExceptionWatchdogTest.class);

    @Test
    public void testSingleExceptionWatchdog() {
        ExceptionWatchdogImpl theExceptionWatchdog = new ExceptionWatchdogImpl();
        AwaitExceptionThread t1 = new AwaitExceptionThread((ExceptionWatchdog<Exception>)theExceptionWatchdog);
        t1.start();
        this.pause(100);
        LOGGER.info((Object)"Calling #nextException( ... )");
        theExceptionWatchdog.throwException(new Exception("Catch me if you can!"));
        this.pause(100);
        theExceptionWatchdog.releaseAll();
        this.pause(100);
        Assertions.assertEquals((int)1, (int)t1.getExceptionCount());
        this.pause(100);
        Assertions.assertFalse((boolean)t1.isAlive());
    }

    @Test
    public void testTwoExceptionWatchdog() {
        ExceptionWatchdogImpl theExceptionWatchdog = new ExceptionWatchdogImpl();
        AwaitExceptionThread t1 = new AwaitExceptionThread((ExceptionWatchdog<Exception>)theExceptionWatchdog);
        t1.start();
        this.pause(100);
        LOGGER.info((Object)"Calling #nextException( ... )");
        theExceptionWatchdog.throwException(new Exception("Catch me if you can!"));
        this.pause(100);
        theExceptionWatchdog.throwException(new Exception("Catch as catch can!"));
        this.pause(100);
        theExceptionWatchdog.releaseAll();
        Assertions.assertEquals((int)t1.getExceptionCount(), (int)2);
        this.pause(100);
        Assertions.assertFalse((boolean)t1.isAlive());
    }

    @Test
    public void testMultiExceptionWatchdog() {
        int i;
        ExceptionWatchdogImpl theExceptionWatchdog = new ExceptionWatchdogImpl();
        AwaitExceptionThread[] t = new AwaitExceptionThread[10];
        for (i = 0; i < 10; ++i) {
            t[i] = new AwaitExceptionThread((ExceptionWatchdog<Exception>)theExceptionWatchdog);
            t[i].start();
        }
        LOGGER.info((Object)"Calling #throwException( ... )");
        this.waitForThreads(t);
        theExceptionWatchdog.throwException(new Exception("Catch me if you can!"));
        this.waitForThreads(t);
        theExceptionWatchdog.throwException(new Exception("Catch as catch can!"));
        this.waitForThreads(t);
        theExceptionWatchdog.releaseAll();
        for (i = 0; i < t.length; ++i) {
            Assertions.assertEquals((int)2, (int)t[i].getExceptionCount());
        }
        this.pause(500);
        for (i = 0; i < t.length; ++i) {
            Assertions.assertFalse((boolean)t[i].isAlive());
        }
    }

    private void waitForThreads(AwaitExceptionThread[] t) {
        for (int i = 0; i < 10; ++i) {
            while (t[i].getState() != Thread.State.WAITING) {
                LOGGER.info((Object)(t[i].getName() + " = " + (Object)((Object)t[i].getState())));
                this.pause(100);
            }
        }
    }

    private void pause(int aTimeout) {
        try {
            Thread.sleep(aTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class AwaitExceptionThread
    extends Thread {
        private ExceptionWatchdog<Exception> _exceptionWatchdog;
        private int _exceptionCount = 0;
        private boolean _isStarted = false;

        public AwaitExceptionThread(ExceptionWatchdog<Exception> aExceptionWatchdog) {
            this._exceptionWatchdog = aExceptionWatchdog;
        }

        @Override
        public void start() {
            super.start();
            RetryCounterImpl theRetry = new RetryCounterImpl(10, 100L);
            while (theRetry.hasNextRetry() && !this._isStarted) {
                theRetry.nextRetry();
            }
        }

        @Override
        public void run() {
            Exception theException;
            LOGGER.info((Object)("Thread [" + Thread.currentThread().getId() + "]: Thread started ..."));
            do {
                theException = null;
                try {
                    this._isStarted = true;
                    LOGGER.info((Object)("Thread [" + Thread.currentThread().getId() + "]: PRE-catch ..."));
                    this._exceptionWatchdog.catchException();
                }
                catch (Exception e) {
                    LOGGER.info((Object)("Thread [" + Thread.currentThread().getId() + "]: POST-catch."));
                    theException = e;
                    ++this._exceptionCount;
                    LOGGER.info((Object)("Thread [" + Thread.currentThread().getId() + "]: Caught an exception \"" + e.getMessage() + "\" <" + this._exceptionCount + ">."));
                }
            } while (theException != null);
            LOGGER.info((Object)("Thread [" + Thread.currentThread().getId() + "]: Thread released <" + this._exceptionCount + ">."));
        }

        public int getExceptionCount() {
            return this._exceptionCount;
        }
    }
}

