/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.controlflow.RetryTimeoutImpl;

public class RetryTimeoutTest {
    private static Logger LOGGER = Logger.getLogger(RetryTimeoutTest.class);
    private static final long RETRY_DELAY_IN_MS = 200L;
    private static final long TIMEOUT_IN_MS = 2000L;

    @Test
    public void testRetryTimeout() {
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(2000L, 200L);
        long theStartTime = System.currentTimeMillis();
        while (theRetryTimeout.hasNextRetry()) {
            theRetryTimeout.nextRetry();
            LOGGER.info((Object)(System.currentTimeMillis() / 1000L + " [" + theRetryTimeout.getRetryCount() + "]"));
        }
        long theEndTime = System.currentTimeMillis();
        Assertions.assertTrue((theEndTime - theStartTime >= 2000L ? 1 : 0) != 0);
        Assertions.assertTrue((theEndTime - theStartTime < 2200L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRainyDayRetryTimeout() {
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(2000L, 200L);
        long theStartTime = System.currentTimeMillis();
        while (theRetryTimeout.hasNextRetry()) {
            theRetryTimeout.nextRetry();
            RetryTimeoutTest retryTimeoutTest = this;
            synchronized (retryTimeoutTest) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.info((Object)(System.currentTimeMillis() / 1000L + " [" + theRetryTimeout.getRetryCount() + "]"));
        }
        long theEndTime = System.currentTimeMillis();
        Assertions.assertEquals((int)1, (int)theRetryTimeout.getRetryCount());
        Assertions.assertTrue((theEndTime - theStartTime < 2400L ? 1 : 0) != 0);
    }
}

