/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.controlflow.RetryCounterImpl;
import org.refcodes.data.LoopExtensionTime;

public class RetryCounterTest {
    private static Logger LOGGER = Logger.getLogger(RetryCounterTest.class);
    private static final int RETRY_DELAY_IN_MILLISECONDS = 300;
    private static final int RETRY_NUMBER = 5;

    @Test
    public void testRetryCounter() {
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 300L);
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        LOGGER.info((Object)("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        while (theRetryCounter.nextRetry()) {
            LOGGER.info((Object)("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [no delay]");
            } else {
                long a = System.currentTimeMillis();
                long b = a - eTime;
                long c = theRetryCounter.getCurrentRetryDelayInMs();
                LOGGER.info((Object)"a := System.currentTimeMillis()");
                LOGGER.info((Object)"b := a - eTime");
                LOGGER.info((Object)"c := theRetryCounter.getCurrentRetryDelayInMs()");
                LOGGER.info((Object)("a := " + a));
                LOGGER.info((Object)("b := " + b));
                LOGGER.info((Object)("c := " + c));
                LOGGER.info((Object)("eTime := " + eTime));
                LOGGER.info((Object)("retryCount := " + theRetryCounter.getRetryCount()));
                LOGGER.info((Object)("retryNumber := " + theRetryCounter.getRetryNumber()));
                LOGGER.info((Object)"b >= c ???");
                Assertions.assertTrue((b >= c ? 1 : 0) != 0);
                LOGGER.info((Object)" [delay]");
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        LOGGER.info((Object)("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        Assertions.assertTrue((System.currentTimeMillis() - eTime <= 300L ? 1 : 0) != 0);
        LOGGER.info((Object)" [no delay]");
        Assertions.assertEquals((int)5, (int)theCounter);
    }

    @Test
    public void testExponentialRetryCounter() {
        LOGGER.info((Object)"##### EXPONENTIAL RETRY COUNTER #####");
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 300L, (long)LoopExtensionTime.MIN.getMilliseconds());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        LOGGER.info((Object)("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        while (theRetryCounter.nextRetry()) {
            long currentTimeMillis;
            LOGGER.info((Object)("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
            if (theRetryCounter.getRetryCount() == 1) {
                currentTimeMillis = System.currentTimeMillis();
                LOGGER.info((Object)("Before-Time := <" + eTime + ">, After-Time := <" + currentTimeMillis + ">, Wait-Time := <" + (currentTimeMillis - eTime) + ">, expected Wait-Time less than := <300>."));
                Assertions.assertTrue((currentTimeMillis - eTime < 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [no delay]");
            } else {
                currentTimeMillis = System.currentTimeMillis();
                LOGGER.info((Object)("Before-Time := <" + eTime + ">, After-Time := <" + currentTimeMillis + ">, Wait-Time := <" + (currentTimeMillis - eTime) + ">, expected Wait-Time := <300>."));
                Assertions.assertTrue((currentTimeMillis - eTime >= 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [delay]");
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        LOGGER.info((Object)("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        LOGGER.info((Object)" [no delay]");
        Assertions.assertEquals((int)5, (int)theCounter);
    }

    @Test
    public void testOneRetryCounter() {
        LOGGER.info((Object)"##### ONE RETRY COUNTER #####");
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(1, 300L, (long)LoopExtensionTime.MIN.getMilliseconds());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        LOGGER.info((Object)("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        while (theRetryCounter.nextRetry()) {
            LOGGER.info((Object)("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [no delay]");
            } else {
                Assertions.assertTrue((System.currentTimeMillis() - eTime >= 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [delay]");
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        LOGGER.info((Object)("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        LOGGER.info((Object)" [no delay]");
        Assertions.assertEquals((int)1, (int)theCounter);
    }

    @Test
    public void testNoneRetryCounter() {
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(0, 300L, (long)LoopExtensionTime.MIN.getMilliseconds());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        LOGGER.info((Object)("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        while (theRetryCounter.nextRetry()) {
            LOGGER.info((Object)("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [no delay]");
            } else {
                Assertions.assertTrue((System.currentTimeMillis() - eTime >= 300L ? 1 : 0) != 0);
                LOGGER.info((Object)" [delay]");
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        LOGGER.info((Object)("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayInMs() + " (delay) - " + theRetryCounter.getCurrentRetryDelayInMs() + " (current delay) - " + theRetryCounter.getNextRetryDelayInMs() + " (next delay) - " + System.currentTimeMillis() + " (after)"));
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        LOGGER.info((Object)" [no delay]");
        Assertions.assertEquals((int)0, (int)theCounter);
    }

    @Test
    public void testRetryCounterExit() {
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 300L, (long)LoopExtensionTime.MIN.getMilliseconds());
        int theCounter = 0;
        long theTime = System.currentTimeMillis();
        LOGGER.info((Object)("Start time = " + theTime));
        while (theRetryCounter.nextRetry()) {
            theRetryCounter.abort();
            Assertions.assertEquals((int)0, (int)theCounter);
            if (theRetryCounter.hasNextRetry()) {
                Assertions.fail((String)"Should not reach this code!");
            }
            ++theCounter;
        }
        LOGGER.info((Object)("End time   = " + System.currentTimeMillis()));
        Assertions.assertTrue((System.currentTimeMillis() - theTime < 300L ? 1 : 0) != 0);
    }
}

