/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.controlflow.DelegationInterceptor;
import org.refcodes.controlflow.DelegationInterceptorComposite;

public class DelegationInterceptorTest {
    @Test
    public void testExitOnAll() {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        Result theResult = new Result();
        DelegationInterceptorComposite theCompoundSequentialInterceptor = new DelegationInterceptorComposite(false, false, new DelegationInterceptor[]{theAddInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.intercept((Object)theResult);
        Assertions.assertEquals((int)2, (int)theResult.getResult());
    }

    @Test
    public void testContinueOnFinished() {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        Result theResult = new Result();
        DelegationInterceptorComposite theCompoundSequentialInterceptor = new DelegationInterceptorComposite(true, false, new DelegationInterceptor[]{theAddInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.intercept((Object)theResult);
        Assertions.assertEquals((int)6, (int)theResult.getResult());
    }

    @Test
    public void testFaliOnError() {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        DivInterceptor theDivInterceptor = new DivInterceptor(0);
        Result theResult = new Result();
        DelegationInterceptorComposite theCompoundSequentialInterceptor = new DelegationInterceptorComposite(false, false, new DelegationInterceptor[]{theDivInterceptor, theAddInterceptor, theAddInterceptor, theAddInterceptor});
        try {
            theCompoundSequentialInterceptor.intercept((Object)theResult);
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContinueOnAll() {
        AddInterceptor theAddInterceptor = new AddInterceptor(2);
        DivInterceptor theDivInterceptor = new DivInterceptor(0);
        Result theResult = new Result();
        DelegationInterceptorComposite theCompoundSequentialInterceptor = new DelegationInterceptorComposite(true, true, new DelegationInterceptor[]{theAddInterceptor, theDivInterceptor, theAddInterceptor, theAddInterceptor});
        theCompoundSequentialInterceptor.intercept((Object)theResult);
        Assertions.assertEquals((int)6, (int)theResult.getResult());
    }

    public class AddInterceptor
    implements DelegationInterceptor<Result> {
        private int _summand;

        public AddInterceptor(int aSummand) {
            this._summand = aSummand;
        }

        public Boolean intercept(Result aWorkPiece) {
            aWorkPiece.setResult(aWorkPiece.getResult() + this._summand);
            return true;
        }
    }

    public class Result {
        private int _result = 0;

        public int getResult() {
            return this._result;
        }

        public void setResult(int aResult) {
            this._result = aResult;
        }
    }

    public class DivInterceptor
    implements DelegationInterceptor<Result> {
        private int _divisor;

        public DivInterceptor(int aDivisor) {
            this._divisor = aDivisor;
        }

        public Boolean intercept(Result aWorkPiece) {
            aWorkPiece.setResult(aWorkPiece.getResult() / this._divisor);
            return true;
        }
    }
}

