/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.LoopExtensionTime;

public class RetryCounterTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");
    private static final int RETRY_DELAY_MILLISECONDS = 300;
    private static final int RETRY_NUMBER = 5;

    @Test
    public void testRetryCounter() {
        RetryCounter theRetryCounter = new RetryCounter(5, 300L);
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        while (theRetryCounter.nextRetry()) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
            }
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [no delay]");
                }
            } else {
                long a = System.currentTimeMillis();
                long b = a - eTime;
                long c = theRetryCounter.getCurrentRetryDelayMillis();
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("a := System.currentTimeMillis()");
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("b := a - eTime");
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("c := theRetryCounter.getCurrentRetryDelayInMs()");
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("a := " + a);
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("b := " + b);
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("c := " + c);
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("eTime := " + eTime);
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("retryCount := " + theRetryCounter.getRetryCount());
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("retryNumber := " + theRetryCounter.getRetryNumber());
                }
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("b >= c ???");
                }
                Assertions.assertTrue((b >= c ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [delay]");
                }
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        Assertions.assertTrue((System.currentTimeMillis() - eTime <= 300L ? 1 : 0) != 0);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(" [no delay]");
        }
        Assertions.assertEquals((int)5, (int)theCounter);
    }

    @Test
    public void testExponentialRetryCounter() {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("##### EXPONENTIAL RETRY COUNTER #####");
        }
        RetryCounter theRetryCounter = new RetryCounter(5, 300L, (long)LoopExtensionTime.MIN.getTimeMillis());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        while (theRetryCounter.nextRetry()) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
            }
            if (theRetryCounter.getRetryCount() == 1) {
                currentTimeMillis = System.currentTimeMillis();
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("Before-Time := <" + eTime + ">, After-Time := <" + currentTimeMillis + ">, Wait-Time := <" + (currentTimeMillis - eTime) + ">, expected Wait-Time less than := <300>.");
                }
                Assertions.assertTrue((currentTimeMillis - eTime < 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [no delay]");
                }
            } else {
                currentTimeMillis = System.currentTimeMillis();
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println("Before-Time := <" + eTime + ">, After-Time := <" + currentTimeMillis + ">, Wait-Time := <" + (currentTimeMillis - eTime) + ">, expected Wait-Time := <300>.");
                }
                Assertions.assertTrue((currentTimeMillis - eTime >= 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [delay]");
                }
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(" [no delay]");
        }
        Assertions.assertEquals((int)5, (int)theCounter);
    }

    @Test
    public void testOneRetryCounter() {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("##### ONE RETRY COUNTER #####");
        }
        RetryCounter theRetryCounter = new RetryCounter(1, 300L, (long)LoopExtensionTime.MIN.getTimeMillis());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        while (theRetryCounter.nextRetry()) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
            }
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [no delay]");
                }
            } else {
                Assertions.assertTrue((System.currentTimeMillis() - eTime >= 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [delay]");
                }
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(" [no delay]");
        }
        Assertions.assertEquals((int)1, (int)theCounter);
    }

    @Test
    public void testNoneRetryCounter() {
        RetryCounter theRetryCounter = new RetryCounter(0, 300L, (long)LoopExtensionTime.MIN.getTimeMillis());
        int theCounter = 0;
        long eTime = System.currentTimeMillis();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("STARTING WITH  := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        while (theRetryCounter.nextRetry()) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("hasNextRetry() := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
            }
            if (theRetryCounter.getRetryCount() == 1) {
                Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [no delay]");
                }
            } else {
                Assertions.assertTrue((System.currentTimeMillis() - eTime >= 300L ? 1 : 0) != 0);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(" [delay]");
                }
            }
            eTime = System.currentTimeMillis();
            ++theCounter;
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("ENDING WITH    := " + eTime + " (before) - " + theRetryCounter.getRetryNumber() + " (retry number) - " + theRetryCounter.getRetryCount() + " (retry count) - " + theRetryCounter.getInitialRetryDelayMillis() + " (delay) - " + theRetryCounter.getCurrentRetryDelayMillis() + " (current delay) - " + theRetryCounter.getNextRetryDelayMillis() + " (next delay) - " + System.currentTimeMillis() + " (after)");
        }
        Assertions.assertTrue((System.currentTimeMillis() - eTime < 300L ? 1 : 0) != 0);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(" [no delay]");
        }
        Assertions.assertEquals((int)0, (int)theCounter);
    }

    @Test
    public void testRetryCounterExit() {
        RetryCounter theRetryCounter = new RetryCounter(5, 300L, (long)LoopExtensionTime.MIN.getTimeMillis());
        int theCounter = 0;
        long theTime = System.currentTimeMillis();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Start time = " + theTime);
        }
        while (theRetryCounter.nextRetry()) {
            theRetryCounter.abort();
            Assertions.assertEquals((int)0, (int)theCounter);
            if (theRetryCounter.hasNextRetry()) {
                Assertions.fail((String)"Should not reach this code!");
            }
            ++theCounter;
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("End time   = " + System.currentTimeMillis());
        }
        Assertions.assertTrue((System.currentTimeMillis() - theTime < 300L ? 1 : 0) != 0);
    }
}

