/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.DoubleNode;
import org.matheclipse.parser.client.eval.DoubleVariable;
import org.matheclipse.parser.client.eval.IBooleanBoolean1Function;
import org.matheclipse.parser.client.eval.IBooleanBoolean2Function;
import org.matheclipse.parser.client.eval.IBooleanDouble2Function;
import org.matheclipse.parser.client.eval.IDouble0Function;
import org.matheclipse.parser.client.eval.IDouble1Function;
import org.matheclipse.parser.client.eval.IDouble2Function;
import org.matheclipse.parser.client.eval.IDoubleCallbackFunction;
import org.matheclipse.parser.client.eval.IDoubleFunction;
import org.matheclipse.parser.client.eval.IDoubleValue;

public class DoubleEvaluator {
    private static final boolean DEBUG = false;
    public static double EPSILON = 1.0E-15;
    private static Map<String, Double> SYMBOL_DOUBLE_MAP = new HashMap<String, Double>();
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP;
    private static Map<String, Object> FUNCTION_DOUBLE_MAP;
    private static Map<String, Object> FUNCTION_BOOLEAN_MAP;
    private IDoubleCallbackFunction fCallbackFunction = null;
    private Map<String, IDoubleValue> fVariableMap = new HashMap<String, IDoubleValue>();
    private Map<String, BooleanVariable> fBooleanVariables = new HashMap<String, BooleanVariable>();
    private ASTNode fNode;

    public IDoubleCallbackFunction getCallbackFunction() {
        return this.fCallbackFunction;
    }

    public void setCallbackFunction(IDoubleCallbackFunction callbackFunction) {
        this.fCallbackFunction = callbackFunction;
    }

    public DoubleEvaluator() {
        this(null);
    }

    public DoubleEvaluator(ASTNode node) {
        this.fNode = node;
    }

    public ASTNode parse(String expression) {
        Parser p = new Parser();
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    public static ASTNode parseNode(String expression) {
        DoubleEvaluator doubleEvaluator = new DoubleEvaluator();
        return doubleEvaluator.parse(expression);
    }

    public double evaluate(String expression) {
        Parser p = new Parser();
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluateNode(ASTNode node) {
        if (node instanceof DoubleNode) {
            return ((DoubleNode)node).doubleValue();
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            IDoubleValue v = this.fVariableMap.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Double dbl = SYMBOL_DOUBLE_MAP.get(node.toString());
            if (dbl != null) {
                return dbl;
            }
        } else if (node instanceof NumberNode) {
            return ((NumberNode)node).doubleValue();
        }
        throw new ArithmeticException("EvalDouble#evaluate(ASTNode) not possible for: " + node.toString());
    }

    public double evaluateFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                    return this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                if (obj instanceof IDoubleFunction) {
                    return ((IDoubleFunction)obj).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (obj instanceof IDouble0Function) {
                        return ((IDouble0Function)obj).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (obj instanceof IDouble1Function) {
                        return ((IDouble1Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3 && obj instanceof IDouble2Function) {
                    return ((IDouble2Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (this.fCallbackFunction != null) {
                    double[] doubleArgs = new double[functionNode.size() - 1];
                    for (int i = 0; i < doubleArgs.length; ++i) {
                        doubleArgs[i] = this.evaluateNode(functionNode.getNode(i + 1));
                    }
                    return this.fCallbackFunction.evaluate(this, functionNode, doubleArgs);
                }
            }
        }
        throw new ArithmeticException("EvalDouble#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticException("EvalDouble#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanDouble2Function) {
                    return ((IBooleanDouble2Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (obj instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticException("EvalDouble#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean doubleOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    functionNode.set(i, new DoubleNode(((NumberNode)functionNode.getNode(i)).doubleValue()));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof DoubleNode)) {
                        doubleOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Double dbl = SYMBOL_DOUBLE_MAP.get(node.toString());
                    if (dbl != null) {
                        functionNode.set(i, new DoubleNode(dbl));
                        continue;
                    }
                    doubleOnly = false;
                    continue;
                }
                doubleOnly = false;
            }
            if (doubleOnly) {
                try {
                    return new DoubleNode(this.evaluateFunction(functionNode));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    public void defineVariable(String variableName, IDoubleValue value) {
        this.fVariableMap.put(variableName, value);
    }

    public IDoubleValue getVariable(String variableName) {
        return this.fVariableMap.get(variableName);
    }

    public void defineVariable(String variableName, BooleanVariable value) {
        this.fBooleanVariables.put(variableName, value);
    }

    public void clearVariables() {
        this.fVariableMap.clear();
        this.fBooleanVariables.clear();
    }

    public static void getVariables(String expression, Set<String> result) {
        Parser p = new Parser();
        ASTNode node = p.parse(expression);
        DoubleEvaluator.getVariables(node, result);
    }

    public static void getVariables(ASTNode node, Set<String> result) {
        Constable obj;
        FunctionNode functionNode;
        if (node instanceof FunctionNode && (functionNode = (FunctionNode)node).size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            for (int i = 1; i < functionNode.size(); ++i) {
                DoubleEvaluator.getVariables(functionNode.getNode(i), result);
            }
        }
        if (node instanceof SymbolNode && (obj = SYMBOL_DOUBLE_MAP.get(node.toString())) == null && (obj = SYMBOL_BOOLEAN_MAP.get(node.toString())) == null) {
            result.add(node.toString());
        }
    }

    static {
        SYMBOL_DOUBLE_MAP.put("Degree", Math.PI / 180);
        SYMBOL_DOUBLE_MAP.put("E", Math.E);
        SYMBOL_DOUBLE_MAP.put("Pi", Math.PI);
        SYMBOL_BOOLEAN_MAP = new HashMap<String, Boolean>();
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new HashMap<String, Object>();
        FUNCTION_BOOLEAN_MAP.put("And", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", new IBooleanBoolean1Function(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return Math.abs(arg1 - arg2) < EPSILON;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 > arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 >= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 < arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return arg1 <= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", new IBooleanDouble2Function(){

            @Override
            public boolean evaluate(double arg1, double arg2) {
                return !(Math.abs(arg1 - arg2) < EPSILON);
            }
        });
        FUNCTION_DOUBLE_MAP = new HashMap<String, Object>();
        FUNCTION_DOUBLE_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_DOUBLE_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_DOUBLE_MAP.put("Set", new SetFunction());
        FUNCTION_DOUBLE_MAP.put("Log", new LogFunction());
        FUNCTION_DOUBLE_MAP.put("Max", new MaxFunction());
        FUNCTION_DOUBLE_MAP.put("Min", new MinFunction());
        FUNCTION_DOUBLE_MAP.put("Plus", new PlusFunction());
        FUNCTION_DOUBLE_MAP.put("Times", new TimesFunction());
        FUNCTION_DOUBLE_MAP.put("Random", new IDouble0Function(){

            @Override
            public double evaluate() {
                return Math.random();
            }
        });
        FUNCTION_DOUBLE_MAP.put("ArcCos", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.acos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ArcSin", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.asin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Ceil", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.ceil(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Cos", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.cos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Cosh", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.cosh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Exp", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.exp(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Floor", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.floor(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Round", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.round(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sign", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.signum(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sin", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.sin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sinh", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.sinh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Sqrt", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.sqrt(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Tan", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.tan(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Tanh", new IDouble1Function(){

            @Override
            public double evaluate(double arg1) {
                return Math.tanh(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Power", new IDouble2Function(){

            @Override
            public double evaluate(double arg1, double arg2) {
                return Math.pow(arg1, arg2);
            }
        });
    }

    static class TimesFunction
    implements IDoubleFunction,
    IDouble2Function {
        TimesFunction() {
        }

        @Override
        public double evaluate(double arg1, double arg2) {
            return arg1 * arg2;
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 1.0;
            for (int i = 1; i < function.size(); ++i) {
                result *= engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class PlusFunction
    implements IDoubleFunction,
    IDouble2Function {
        PlusFunction() {
        }

        @Override
        public double evaluate(double arg1, double arg2) {
            return arg1 + arg2;
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 0.0;
            for (int i = 1; i < function.size(); ++i) {
                result += engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class MinFunction
    implements IDoubleFunction,
    IDouble2Function {
        MinFunction() {
        }

        @Override
        public double evaluate(double arg1, double arg2) {
            return Math.min(arg1, arg2);
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.MAX_VALUE;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                double temp = Math.min(result, engine.evaluateNode(function.getNode(i)));
                if (!(temp < result)) continue;
                result = temp;
            }
            return result;
        }
    }

    static class MaxFunction
    implements IDoubleFunction,
    IDouble2Function {
        MaxFunction() {
        }

        @Override
        public double evaluate(double arg1, double arg2) {
            return Math.max(arg1, arg2);
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.MIN_VALUE;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                double temp = Math.max(result, engine.evaluateNode(function.getNode(i)));
                if (!(temp > result)) continue;
                result = temp;
            }
            return result;
        }
    }

    static class SetFunction
    implements IDoubleFunction {
        SetFunction() {
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            if (function.size() != 3) {
                throw new ArithmeticException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) needs 2 arguments: " + function.toString());
            }
            if (!(function.getNode(1) instanceof SymbolNode)) {
                throw new ArithmeticException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) symbol required on the left hand side: " + function.toString());
            }
            String variableName = ((SymbolNode)function.getNode(1)).getString();
            double result = engine.evaluateNode(function.getNode(2));
            IDoubleValue dv = engine.getVariable(variableName);
            if (dv == null) {
                dv = new DoubleVariable(result);
            } else {
                dv.setValue(result);
            }
            engine.defineVariable(variableName, dv);
            return result;
        }
    }

    static class CompoundExpressionFunction
    implements IDoubleFunction {
        CompoundExpressionFunction() {
        }

        @Override
        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = Double.NaN;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                result = engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class LogFunction
    implements IDouble1Function,
    IDouble2Function {
        LogFunction() {
        }

        @Override
        public double evaluate(double arg1) {
            return Math.log(arg1);
        }

        @Override
        public double evaluate(double base, double z) {
            return Math.log(z) / Math.log(base);
        }
    }

    static class ArcTanFunction
    implements IDouble1Function,
    IDouble2Function {
        ArcTanFunction() {
        }

        @Override
        public double evaluate(double arg1) {
            return Math.atan(arg1);
        }

        @Override
        public double evaluate(double arg1, double arg2) {
            return Math.atan2(arg1, arg2);
        }
    }
}

