package org.refcodes.criteria;

import static org.junit.jupiter.api.Assertions.*;

import java.text.ParseException;

import org.junit.jupiter.api.Test;
import org.refcodes.textual.ReplaceTextBuilderImpl;

/**
 * The Class ExpressionCriteriaFactoryImplTest.
 */
public class ExpressionCriteriaFactoryImplTest {

	private static boolean IS_LOG_TESTS = Boolean.getBoolean( "log.tests" );

	// /////////////////////////////////////////////////////////////////////////
	// TESTS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Tests the {@link ExpressionCriteriaFactoryImpl} which parses query
	 * strings to create {@link Criteria} instances.
	 *
	 * @throws ParseException the parse exception
	 */
	@Test
	public void testQueries() throws ParseException {
		if ( IS_LOG_TESTS ) System.out.println( "Testing the expression criteria factory:".toUpperCase() );
		ExpressionCriteriaFactoryImpl theExpressionFactory = new ExpressionCriteriaFactoryImpl();
		ExpressionQueryFactoryImpl theQueryFactory = new ExpressionQueryFactoryImpl();
		Criteria eCriteria;
		String eQuery, eAssert;
		for ( int i = 0; i < QueryFixure.QUERIES.length; i++ ) {
			eCriteria = theExpressionFactory.fromQuery( QueryFixure.QUERIES[i] );
			if ( IS_LOG_TESTS ) System.out.println( "   QUERY[" + i + "] := " + QueryFixure.QUERIES[i] );
			eQuery = theQueryFactory.fromCriteria( eCriteria );
			eAssert = new ReplaceTextBuilderImpl().withText( eQuery ).withFindText( "IS NOT" ).withReplaceText( "!=" ).toString();
			eAssert = new ReplaceTextBuilderImpl().withText( eAssert ).withFindText( "IS" ).withReplaceText( "=" ).toString();
			if ( IS_LOG_TESTS ) System.out.println( "CRITERIA[" + i + "] := " + eQuery );
			assertEquals( QueryFixure.QUERIES[i].replaceAll( "\"", "'" ), eAssert );
		}
	}
}