package org.refcodes.criteria;

import static org.junit.jupiter.api.Assertions.*;
import static org.refcodes.criteria.CriteriaSugar.*;

import org.junit.jupiter.api.Test;

/**
 * The Class ExpressionQueryFactoryTest.
 */
public class ExpressionQueryFactoryTest {

	private static boolean IS_LOG_TESTS = Boolean.getBoolean( "log.tests" );

	// /////////////////////////////////////////////////////////////////////////
	// TESTS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Tests the {@link ExpressionQueryFactoryImpl} which creates query strings
	 * from {@link Criteria} instances which could be used by SQL statements.
	 */
	@Test
	public void testExpressionQueryFactory() {
		if ( IS_LOG_TESTS ) System.out.println( "Testing the expression query factory:".toUpperCase() );
		Criteria theCriteria = not( and( not( and( notEqualWith( "City", "Berlin" ), lessThan( "ZIP", 30000 ) ) ), greaterThan( "AGE", 65 ) ) );
		ExpressionQueryFactoryImpl theQueryFactory = new ExpressionQueryFactoryImpl();
		String theQuery = theQueryFactory.fromCriteria( theCriteria );
		if ( IS_LOG_TESTS ) System.out.println( "EXPECTED := " + QueryFixure.QUERIES[0] );
		if ( IS_LOG_TESTS ) System.out.println( "   QUERY := " + theQuery );
		assertEquals( QueryFixure.QUERIES[0], theQuery );

		theCriteria = or( not( and( equalWith( "City", "Berlin" ), equalWith( "ZIP", 10337 ) ) ), greaterOrEqualThan( "Age", 18 ) );
		theQueryFactory = new ExpressionQueryFactoryImpl();
		theQuery = theQueryFactory.fromCriteria( theCriteria );
		if ( IS_LOG_TESTS ) System.out.println( "EXPECTED := " + QueryFixure.QUERIES[1] );
		if ( IS_LOG_TESTS ) System.out.println( "   QUERY := " + theQuery );
		assertEquals( QueryFixure.QUERIES[1], theQuery );
	}
}
