/*
 * Copyright 2005-2008 Axel Kramer (axellclk@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/TEXT-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.matheclipse.parser.client.ast;

/**
 * A node for a parsed floating number string. The floating point string is not
 * converted to a binary float or double type. only th String representation is
 * stored.
 */
public class FloatNode extends NumberNode {
	/**
	 * Instantiates a new float node.
	 * 
	 * @param value the value
	 */
	public FloatNode( final String value ) {
		super( value );
	}

	/**
	 * {@inheritDoc} Equals.
	 */
	@Override
	public boolean equals( Object obj ) {
		if ( obj instanceof FloatNode ) {
			return fStringValue.equals( ((FloatNode) obj).fStringValue ) && sign == ((FloatNode) obj).sign;
		}
		return false;
	}
}
