/*
 * Copyright 2005-2009 Axel Kramer (axellclk@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/TEXT-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.matheclipse.parser.client.eval.api;

import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.eval.ComplexNode;
import org.matheclipse.parser.client.eval.DoubleNode;

/**
 * Visitor interface to run through an abstract syntax tree (AST) generated by
 * the parser.
 *
 * @param <DATA> the generic type
 * @param <DATA_VARIABLE> the generic type
 * @param <USER_DATA_TYPE> a user-defined data type
 */
public interface IASTVisitor<DATA, DATA_VARIABLE, USER_DATA_TYPE> extends IEvaluator<DATA, DATA_VARIABLE> {
	/**
	 * Before a visitor run starts this method will be called.
	 * 
	 * @param data the new up
	 */
	public void setUp( USER_DATA_TYPE data );

	/**
	 * After a visitor run has finished this method will be called. Typically
	 * this method will be called before the getResult() method.
	 */
	public void tearDown();

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( ComplexNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( DoubleNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( FunctionNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( FloatNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( FractionNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( IntegerNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( PatternNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( StringNode node );

	/**
	 * Visit.
	 * 
	 * @param node the node
	 * 
	 * @return the data
	 */
	public DATA visit( SymbolNode node );
}
