/*
 * Copyright 2005-2008 Axel Kramer (axellclk@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/TEXT-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.matheclipse.parser.client.operator;

import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.ast.IntegerNode;

/**
 * The Class DivideOperator.
 */
public class DivideOperator extends InfixOperator {
	/**
	 * Instantiates a new divide operator.
	 * 
	 * @param oper the oper
	 * @param functionName the function name
	 * @param precedence the precedence
	 * @param grouping the grouping
	 */
	public DivideOperator( final String oper, final String functionName, final int precedence, final int grouping ) {
		super( oper, functionName, precedence, grouping );
	}

	/**
	 * {@inheritDoc} Creates the function.
	 */
	@Override
	public ASTNode createFunction( final IParserFactory factory, final ASTNode lhs, final ASTNode rhs ) {
		if ( rhs instanceof IntegerNode ) {
			if ( lhs instanceof IntegerNode ) {
				return new FractionNode( (IntegerNode) lhs, (IntegerNode) rhs );
			}
			return factory.createFunction( factory.createSymbol( "Times" ), lhs, new FractionNode( IntegerNode.C1, (IntegerNode) rhs ) );
		}
		return factory.createFunction( factory.createSymbol( "Times" ), lhs, factory.createFunction( factory.createSymbol( "Power" ), rhs, factory.createInteger( -1 ) ) );
	}
}
