/*
 * Copyright 2005-2008 Axel Kramer (axellclk@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/TEXT-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.matheclipse.parser.client.operator;

/**
 * The Class Operator.
 */
public abstract class Operator {

	protected String fFunctionName;

	protected String fOperatorString;

	protected int fPrecedence;

	/**
	 * Instantiates a new operator.
	 * 
	 * @param oper the oper
	 * @param functionName the function name
	 * @param precedence the precedence
	 */
	public Operator( final String oper, final String functionName, final int precedence ) {
		fOperatorString = oper;
		fFunctionName = functionName;
		fPrecedence = precedence;
	}

	/**
	 * {@inheritDoc} Equals.
	 */
	@Override
	public boolean equals( final Object obj ) {
		if ( obj instanceof Operator ) {
			return fFunctionName.equals( ((Operator) obj).fFunctionName );
		}
		return false;
	}

	/**
	 * Gets the function name.
	 * 
	 * @return the name of the head of the associated function
	 */
	public String getFunctionName() {
		return fFunctionName;
	}

	/**
	 * Gets the operator string.
	 * 
	 * @return the operator string of this operator
	 */
	public String getOperatorString() {
		return fOperatorString;
	}

	/**
	 * Gets the precedence.
	 * 
	 * @return the precedence of this operator
	 */
	public int getPrecedence() {
		return fPrecedence;
	}

	/**
	 * Hash code.
	 * 
	 * @return the hashCode of the function name
	 */
	@Override
	public int hashCode() {
		return fFunctionName.hashCode();
	}

	/**
	 * To string.
	 * 
	 * @return the string
	 */
	@Override
	public String toString() {
		return "[" + fFunctionName + "," + fOperatorString + "," + fPrecedence + "]";
	}

}
