// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.criteria;

/**
 * Base class with the base {@link org.refcodes.criteria.CriteriaLeaf}
 * functionality provided for {@link org.refcodes.criteria.CriteriaLeaf}
 * implementations.
 *
 * @param <T> the generic type
 * 
 * @author steiner
 * 
 * @version $Id: $Id
 */
public abstract class AbstractCriteriaLeaf<T> extends AbstractCriteria implements CriteriaLeaf<T> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _key;

	private T _value;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link org.refcodes.criteria.CriteriaLeaf} with the given
	 * name.
	 *
	 * @param aName The name of the {@link org.refcodes.criteria.CriteriaLeaf}.
	 */
	public AbstractCriteriaLeaf( String aName ) {
		super( aName );
	}

	/**
	 * Constructs a {@link org.refcodes.criteria.CriteriaLeaf} with the given
	 * name, key and value.
	 *
	 * @param aName The name of the {@link org.refcodes.criteria.CriteriaLeaf}.
	 * @param aKey The value for the {@link org.refcodes.criteria.CriteriaLeaf}.
	 * @param aValue the value
	 */
	public AbstractCriteriaLeaf( String aName, String aKey, T aValue ) {
		super( aName );
		_key = aKey;
		_value = aValue;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public T getValue() {
		return _value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getKey() {
		return _key;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setKey( String aKey ) {
		_key = aKey;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue( T aValue ) {
		_value = aValue;
	}
}
