// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.criteria;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Base class with the base {@link org.refcodes.criteria.CriteriaNode}
 * functionality provided for {@link org.refcodes.criteria.CriteriaNode}
 * implementations.
 *
 * @author steiner
 * 
 * @version $Id: $Id
 */
public abstract class AbstractCriteriaNode extends AbstractCriteria implements CriteriaNode {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private List<Criteria> _children = new ArrayList<Criteria>();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link org.refcodes.criteria.CriteriaNode} with the given
	 * name.
	 *
	 * @param aName The name of the {@link org.refcodes.criteria.CriteriaNode}.
	 */
	public AbstractCriteriaNode( String aName ) {
		super( aName );
	}

	/**
	 * Constructs a {@link org.refcodes.criteria.CriteriaNode} with the given
	 * name and the provided {@link org.refcodes.criteria.Criteria} children.
	 *
	 * @param aName The name of the {@link org.refcodes.criteria.CriteriaNode}.
	 * @param aChildren The {@link org.refcodes.criteria.Criteria} children to
	 *        be contained in the {@link org.refcodes.criteria.CriteriaNode}.
	 */
	public AbstractCriteriaNode( String aName, Criteria... aChildren ) {
		super( aName );
		Collections.addAll( _children, aChildren );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addChild( Criteria aChild ) throws IllegalStateException, IllegalArgumentException {
		_children.add( aChild );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<Criteria> getChildren() {
		return _children;
	}
}
