// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.criteria;

import org.refcodes.struct.Relation.RelationBuilder;

/**
 * A CriteriaLeaf tree leaf is an expression usually relating to a key (for
 * example identifying a table's column in a database) and a value, both of
 * which consolidating an expression (for example "City = 'Munich'").
 *
 * @param <T> The type of the {@link CriteriaLeaf} instance's value.
 */
public interface CriteriaLeaf<T> extends Criteria, RelationBuilder<String, T> {
	@Override
	default CriteriaLeaf<T> withValue( T aValue ) {
		setValue( aValue );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default CriteriaLeaf<T> withKey( String aKey ) {
		setKey( aKey );
		return this;
	}
}
