// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.criteria;

import org.refcodes.exception.AbstractRuntimeException;

/**
 * The Class CriteriaRuntimeException.
 *
 * @author steiner
 * 
 * @version $Id: $Id
 */
public abstract class CriteriaRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public CriteriaRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public CriteriaRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public CriteriaRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param message the message
	 */
	public CriteriaRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public CriteriaRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new criteria runtime exception.
	 *
	 * @param cause the cause
	 */
	public CriteriaRuntimeException( Throwable cause ) {
		super( cause );
	}

	/**
	 * The Class CriteriaCriteriaRuntimeException.
	 */
	static abstract class CriteriaCriteriaRuntimeException extends CriteriaRuntimeException implements CriteriaAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Criteria _criteria;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_criteria = aCriteria;
		}

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_criteria = aCriteria;
		}

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param message the message
		 * @param cause the cause
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, String message, Throwable cause ) {
			super( message, cause );
			_criteria = aCriteria;
		}

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param message the message
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, String message ) {
			super( message );
			_criteria = aCriteria;
		}

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_criteria = aCriteria;
		}

		/**
		 * Instantiates a new criteria criteria runtime exception.
		 *
		 * @param aCriteria the criteria
		 * @param cause the cause
		 */
		public CriteriaCriteriaRuntimeException( Criteria aCriteria, Throwable cause ) {
			super( cause );
			_criteria = aCriteria;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Gets the criteria.
		 *
		 * @return the criteria
		 */
		@Override
		public Criteria getCriteria() {
			return _criteria;
		}
	}
}
