// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.criteria;

/**
 * A special specialization of the {@link org.refcodes.criteria.CriteriaNode},
 * allowing just one child. This is required for nodes representing for example
 * a logical NOT. ATTENTION: Make sure you overwrite the
 * {@link #addChild(Criteria)} method to throw an according exception in case
 * more than one child {@link org.refcodes.criteria.Criteria} is to be stored in
 * the {@link org.refcodes.criteria.SingleCriteriaNode}.
 *
 * @author steiner
 * 
 * @version $Id: $Id
 */
public interface SingleCriteriaNode extends CriteriaNode {

	/**
	 * Returns the single child {@link org.refcodes.criteria.Criteria} being
	 * stored in this {@link org.refcodes.criteria.CriteriaNode}.
	 *
	 * @return The according child {@link org.refcodes.criteria.Criteria}.
	 */
	Criteria getChild();

	/**
	 * Sets the single child {@link org.refcodes.criteria.Criteria} to be stored
	 * in this {@link org.refcodes.criteria.CriteriaNode}.
	 *
	 * @param aCriteria The according child
	 *        {@link org.refcodes.criteria.Criteria}.
	 */
	void setChild( Criteria aCriteria );
}
