// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * The refcodes-criteria framework allows the construction of criteria for
 * selecting or filtering or identifying issues (such issues could be the
 * selection of entries from a database).
 * <p>
 * This implies the creation of query statements from the criteria which can be
 * applied to data sinks; such as databases (SQL like statements). In turn, this
 * also implies parsing of criteria trees from a query statement (provided as
 * logical operators in your code). Such parsable query statement can look as
 * follows:
 * 
 * <pre>
 * ( ( ( City = 'Berlin' ) OR ( City = 'Munich' ) ) AND ( Surname = 'Miller' ) )
 * </pre>
 * 
 * A dedicated CriteriaFactory implementation is required (and already provided)
 * for parsing the above query statement.
 * <p>
 * The refcodes-criteria framework consists of the following components:
 * <p>
 * A Criteria represents an atomic query or atomic logical operator with which
 * complex queries can be constructed in an object oriented manner by combining
 * the Criteria instances in a tree structure. From this tree structure, query
 * statements can be generated. In turn, a query statement provided as logical
 * operators can be parsed for the construction of a Criteria tree (see example
 * above)s.
 * <p>
 * This means that a Criteria query is constructed from a Criteria tree with
 * CriteriaNode node instances and CriteriaLeaf leaf instances. A node may
 * contain other node instances and/or other leaf instances, all of which being
 * the node's children.
 * <h2>{@link org.refcodes.criteria.CriteriaNode}:</h2> A CriteriaNode tree node
 * may represent a logical AND or a logical OR or a logical NOT applied on the
 * node's children Criteria (CriteriaNode instances and CriteriaLeaf instances).
 * <h2>{@link org.refcodes.criteria.CriteriaLeaf}:</h2> A CriteriaLeaf tree leaf
 * is an expression usually relating to a key (for example identifying a table's
 * column in a database) and a value, both of which consolidating an expression
 * (for example "City = 'Munich'").
 * <h2>{@link org.refcodes.criteria.SingleCriteriaNode}:</h2> A special
 * specialization of the CriteriaNode, allowing just one child. This is required
 * for nodes representing for example a logical NOT.
 * <h2>{@link org.refcodes.criteria.Criteria}:</h2> The Criteria itself is the
 * base definition of functionality which the CriteriaNode and CriteriaLeaf
 * implementations are to support. Mainly, a Criteria is to have a name (for
 * example "AND", "OR", "LESS_THAN" and so on).
 * <h2>{@link org.refcodes.criteria.CriteriaSugar}:</h2> DeclarativeCreteria is
 * a utility class which may be statically imported in order to allow
 * declarative definitions of Criteria trees. In the Java code this may look as
 * follows (simplified): <code>
 * import static org.refcodes.criteria.CriteriaSugar.*;
 * ...
 * Criteria theCriteria = and( or( equalWith( &quot;City&quot;, &quot;Berlin&quot; ), equalWith( &quot;City&quot;, &quot;Munich&quot; ) ), equalWith( &quot;Surname&quot;, &quot;Miller&quot; ) );
 * ...
 * </code>
 * <h2>{@link org.refcodes.criteria.CriteriaFactory}:</h2> The CriteriaFactory
 * constructs a Criteria (tree) from the provided query. The syntax of the query
 * is implementation specific and may look as follows:
 * 
 * <pre>
 * ( ( ( City = 'Berlin' ) OR ( City = 'Munich' ) ) AND ( Surname = 'Miller' ) )
 * </pre>
 * 
 * <strong>CAUTION: The syntax supported for the query statement is
 * implementation depended!</strong>
 * <p>
 * The ExpressionCriteriaFactoryImpl implements a CriteriaFactory being capable
 * of parsing the above query.
 * <h2>{@link org.refcodes.criteria.QueryFactory}:</h2> The QueryFactory
 * generates a query from the provided Criteria (tree). The resulting query may
 * be targeted at a database and therefore be SQL like.
 * <p>
 * <strong>CAUTION: The syntax supported for the query statement is
 * implementation depended!</strong>
 */
package org.refcodes.criteria;
